/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.stutter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.ajoberstar.gradle.stutter.GenerateStutterLocks;
import org.ajoberstar.gradle.stutter.StutterExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.util.GradleVersion;

public class StutterPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        StutterExtension stutter = (StutterExtension)project.getExtensions().create("stutter", StutterExtension.class, new Object[0]);
        stutter.getLockFile().convention(project.getLayout().getProjectDirectory().file("stutter.lockfile"));
        stutter.getSparse().convention((Object)true);
        project.getPluginManager().withPlugin("java", plugin -> {
            this.createWriteLocksTask(project, stutter);
            this.configureCompatTest(project, stutter);
        });
    }

    private void createWriteLocksTask(Project project, StutterExtension stutter) {
        project.getTasks().register("stutterWriteLocks", GenerateStutterLocks.class, task -> {
            task.setGroup("plugin development");
            task.setDescription("Generate lock files of Gradle versions to test for compatibility.");
            task.getOutputFile().set((Provider)stutter.getLockFile());
            task.getMatrices().set(stutter.getMatrices());
            task.getSparse().set(stutter.getSparse());
        });
    }

    private void configureCompatTest(Project project, StutterExtension stutter) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        sourceSets.register("compatTest", sourceSet -> this.createCompatTestTasks(project, stutter, (SourceSet)sourceSet));
    }

    private void createCompatTestTasks(Project project, StutterExtension stutter, SourceSet sourceSet) {
        Map<String, Set<GradleVersion>> lockedVersions = this.getLockedVersions(project, stutter);
        TaskProvider test = project.getTasks().named("test");
        JavaToolchainService javaToolchains = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class);
        TaskProvider root = project.getTasks().register("compatTest", task -> {
            task.setGroup("verification");
            task.setDescription("Run compatibility tests against all supported Gradle and Java versions.");
        });
        stutter.getMatrices().all(matrix -> {
            String capitalizedMatrixName = matrix.getName().substring(0, 1).toUpperCase() + matrix.getName().substring(1);
            String matrixTaskName = "compatTest" + capitalizedMatrixName;
            TaskProvider matrixRoot = project.getTasks().register(matrixTaskName, task -> {
                task.setGroup("verification");
                task.setDescription(String.format("Run compatibility tests against all %s supported Gradle versions.", matrix.getName()));
            });
            root.configure(rootTask -> rootTask.dependsOn(new Object[]{matrixRoot}));
            Set matrixLockedVersions = lockedVersions.getOrDefault(matrix.getName(), Set.of());
            if (matrixLockedVersions.isEmpty()) {
                matrixRoot.configure(task -> task.doFirst(t -> project.getLogger().warn("Stutter matrix {} has no locked Gradle versions. Configure the stutter extension and run stutterWriteLocks.", (Object)matrix.getName())));
            }
            matrixLockedVersions.forEach(gradleVersion -> {
                String taskName = String.format("compatTest%sGradle%s", capitalizedMatrixName, gradleVersion.getVersion());
                TaskProvider versionTask = project.getTasks().register(taskName, Test.class, task -> {
                    task.setGroup("verification");
                    task.setDescription(String.format("Run compatibility tests for %s against Gradle %s", matrix.getName(), gradleVersion.getVersion()));
                    task.getJavaLauncher().set(matrix.getJavaLauncher());
                    task.setTestClassesDirs(sourceSet.getOutput().getClassesDirs());
                    Callable<FileCollection> classpath = () -> sourceSet.getRuntimeClasspath();
                    task.setClasspath((FileCollection)project.files(new Object[]{classpath}));
                    task.systemProperty("compat.gradle.version", (Object)gradleVersion.getVersion());
                    task.shouldRunAfter(new Object[]{test});
                });
                matrixRoot.configure(rootTask -> rootTask.dependsOn(new Object[]{versionTask}));
            });
        });
        project.getPluginManager().withPlugin("java-gradle-plugin", plugin2 -> {
            GradlePluginDevelopmentExtension gradlePlugin = (GradlePluginDevelopmentExtension)project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
            gradlePlugin.testSourceSets(new SourceSet[]{sourceSet});
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Set<GradleVersion>> getLockedVersions(Project project, StutterExtension stutter) {
        File lockFile = ((RegularFile)stutter.getLockFile().forUseAtConfigurationTime().get()).getAsFile();
        if (!lockFile.exists()) {
            project.getLogger().warn("No Stutter lockfile found at: {}", (Object)lockFile);
            return Map.of();
        }
        Provider lockFileBytes = project.getProviders().fileContents((Provider)stutter.getLockFile()).getAsBytes().forUseAtConfigurationTime();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])lockFileBytes.get());){
            Map<String, Set<GradleVersion>> map;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                map = reader.lines().filter(line -> !line.startsWith("#")).map(line -> {
                    String[] parts = line.split("=", 2);
                    String matrixName = parts[0];
                    Set gradleVersions = Arrays.stream(parts[1].split(",")).map(GradleVersion::version).collect(Collectors.toSet());
                    return Map.entry(matrixName, gradleVersions);
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            return map;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

