/*
 * Decompiled with CFR 0.152.
 */
package org.akhikhl.gretty;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;

public class FilteringClassLoader
extends WebAppClassLoader {
    private final List<String> serverClasses = new ArrayList<String>();
    private final List<String> serverResources = new ArrayList<String>();

    public FilteringClassLoader(WebAppClassLoader.Context context) throws IOException {
        super(context);
    }

    public FilteringClassLoader(ClassLoader parent, WebAppClassLoader.Context context) throws IOException {
        super(parent, context);
    }

    public void addServerClass(String serverClass) {
        this.serverClasses.add(serverClass);
        this.serverResources.add(serverClass.replace('.', '/'));
        this.serverResources.add("META-INF/services/" + serverClass);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String serverClass : this.serverClasses) {
            if (!name.startsWith(serverClass)) continue;
            Class c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        for (String serverResource : this.serverResources) {
            if (!name.startsWith(serverResource)) continue;
            Enumeration[] tmp = new Enumeration[]{FilteringClassLoader.getBootstrapResources(name), this.findResources(name)};
            return new CompoundEnumeration(tmp);
        }
        return super.getResources(name);
    }

    private static Enumeration<URL> getBootstrapResources(String name) throws IOException {
        final Enumeration e = FilteringClassLoader.getBootstrapClassPath().getResources(name);
        return new Enumeration<URL>(){

            @Override
            public URL nextElement() {
                return ((Resource)e.nextElement()).getURL();
            }

            @Override
            public boolean hasMoreElements() {
                return e.hasMoreElements();
            }
        };
    }

    static URLClassPath getBootstrapClassPath() {
        return Launcher.getBootstrapClassPath();
    }
}

