/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.collect.Iterables;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.CartesianProductIterator;

public class CartesianProduct<T>
extends AbstractCollection<List<T>> {
    protected List<? extends Iterable<? extends T>> collections;
    protected boolean inPlace;

    public CartesianProduct(List<? extends Iterable<? extends T>> collections) {
        this(false, collections);
    }

    public CartesianProduct(boolean inPlace, List<? extends Iterable<? extends T>> collections) {
        this.inPlace = inPlace;
        this.collections = collections;
    }

    public static <T> CartesianProduct<T> create(List<? extends Iterable<? extends T>> collections) {
        return new CartesianProduct<T>(false, collections);
    }

    public static <T> CartesianProduct<T> create(Iterable<? extends Iterable<? extends T>> iterables) {
        ArrayList<Iterable<T>> tmp = new ArrayList<Iterable<T>>();
        for (Iterable<T> iterable : iterables) {
            tmp.add(iterable);
        }
        return new CartesianProduct<T>(false, tmp);
    }

    public static <T> CartesianProduct<T> create(T[] ... collections) {
        ArrayList<List<T>> tmp = new ArrayList<List<T>>(collections.length);
        for (T[] item : collections) {
            tmp.add(Arrays.asList(item));
        }
        return new CartesianProduct<T>(false, tmp);
    }

    public static <T> CartesianProduct<T> create(Iterable<? extends T> ... collections) {
        return new CartesianProduct<T>(false, Arrays.asList(collections));
    }

    @Override
    public Iterator<List<T>> iterator() {
        return new CartesianProductIterator(this.inPlace, this.collections);
    }

    @Override
    public int size() {
        int size = this.collections.isEmpty() ? 0 : 1;
        for (Iterable<? extends T> iterable : this.collections) {
            size *= Iterables.size(iterable);
        }
        return size;
    }
}

