/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class MapUtils {
    public static <T> int addWithIntegerAutoIncrement(Map<T, Integer> map, T key) {
        int result = map.computeIfAbsent(key, k -> map.size());
        return result;
    }

    public static <T> long addWithLongAutoIncrement(Map<T, Long> map, T key) {
        long result = map.computeIfAbsent(key, k -> map.size());
        return result;
    }

    public static void removeAll(Map<?, ?> map, Iterable<?> items) {
        for (Object o : items) {
            map.remove(o);
        }
    }

    public static <K, V> void putForAll(Map<K, V> map, Iterable<K> keys, V value) {
        for (K key : keys) {
            map.put(key, value);
        }
    }

    public static <K, V> boolean isCompatible(Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b) {
        Sets.SetView commonKeys = Sets.intersection(a.keySet(), b.keySet());
        boolean result = MapUtils.isCompatible(commonKeys, a, b);
        return result;
    }

    public static <K, V> boolean isCompatible(Set<? extends K> keysToTest, Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b) {
        V bv;
        K key;
        V av;
        boolean result = true;
        Iterator<K> iterator = keysToTest.iterator();
        while (iterator.hasNext() && (result = Objects.equal(av = a.get(key = iterator.next()), bv = b.get(key)))) {
        }
        return result;
    }

    @Deprecated
    public static <K, V> boolean isPartiallyCompatible(Map<K, V> a, Map<K, V> b) {
        boolean result = MapUtils.isCompatible(a, b);
        return result;
    }

    public static <K, V> Multimap<V, K> reverse(Map<K, V> map) {
        HashMultimap result = HashMultimap.create();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V> V getOrElse(Map<? extends K, ? extends V> map, K key, V elze) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return elze;
    }

    public static <K, V> Map<K, V> createChainMap(Map<K, ?> a, Map<?, V> b) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, ?> entry : a.entrySet()) {
            if (!b.containsKey(entry.getValue())) continue;
            result.put(entry.getKey(), b.get(entry.getValue()));
        }
        return result;
    }

    public static <K, V> V getOrCreate(Map<K, V> map, K key, Class<V> clazz, Object ... ctorArgs) {
        V result = map.get(key);
        if (result == null) {
            if (ctorArgs.length > 0) {
                throw new RuntimeException("Constructor arguments not supported yet");
            }
            try {
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            map.put(key, result);
        }
        return result;
    }

    public static <K, V, R extends Map<K, V>> R mergeCompatible(Iterable<? extends Map<? extends K, ? extends V>> maps, Supplier<R> resultSupplier) {
        Map result = (Map)resultSupplier.get();
        for (Map<K, V> map : maps) {
            if (MapUtils.isCompatible(map, result)) {
                result.putAll(map);
                continue;
            }
            result = null;
            break;
        }
        return (R)result;
    }

    public static <K, V, R extends Map<K, V>> R mergeCompatible(Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b, Supplier<R> resultSupplier) {
        R result = MapUtils.mergeCompatible(Arrays.asList(a, b), resultSupplier);
        return result;
    }
}

