/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.cache;

import java.util.Iterator;
import java.util.List;

public class IndexBasedIterator<T>
implements Iterator<T> {
    protected List<T> list;
    protected int offset;

    public IndexBasedIterator(List<T> list) {
        this(list, 0);
    }

    public IndexBasedIterator(List<T> list, int offset) {
        this.list = list;
        this.offset = offset;
    }

    @Override
    public boolean hasNext() {
        boolean result;
        try {
            this.list.get(this.offset);
            result = true;
        }
        catch (IndexOutOfBoundsException e) {
            result = false;
        }
        return result;
    }

    @Override
    public T next() {
        T result = this.list.get(this.offset);
        ++this.offset;
        return result;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return "IndexBasedIterator [list=" + this.list + ", offset=" + this.offset + "]";
    }
}

