/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.cache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.aksw.commons.collections.cache.CacheImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamBackedList<T>
extends CacheImpl<T> {
    private static final Logger logger = LoggerFactory.getLogger(StreamBackedList.class);
    protected Stream<T> stream;
    protected Future<?> future;

    public StreamBackedList(Stream<T> stream) {
        this(stream, Executors.newSingleThreadExecutor(), true);
    }

    public StreamBackedList(Stream<T> stream, ExecutorService es) {
        this(stream, es, false);
    }

    public StreamBackedList(Stream<T> stream, ExecutorService es, boolean shutdownExecutorService) {
        super(new ArrayList());
        this.stream = stream;
        this.future = es.submit(() -> {
            try {
                Iterator it = stream.iterator();
                while (it.hasNext() && !Thread.interrupted()) {
                    Object item = it.next();
                    this.add(item);
                }
                this.setComplete();
            }
            catch (Exception e) {
                logger.warn("Unexpected error", (Throwable)e);
                this.setAbandoned();
            }
            finally {
                try {
                    stream.close();
                    super.close();
                }
                catch (Exception e) {
                    logger.warn("Unexpected error", (Throwable)e);
                }
            }
        });
        if (shutdownExecutorService) {
            es.shutdown();
        }
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.isComplete()) {
                this.future.get();
            } else {
                this.future.cancel(true);
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error", (Throwable)e);
        }
    }
}

