/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.reversible;

import com.google.common.collect.SetMultimap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.reversible.AbstractSetMultimap;
import org.aksw.commons.collections.reversible.ReversibleMap;
import org.aksw.commons.collections.reversible.ReversibleSetMultimap;

public class ReversibleSetMultimapImpl<K, V>
extends AbstractSetMultimap<K, V>
implements ReversibleSetMultimap<K, V> {
    protected ReversibleMap<V, K> reverse;
    protected SetMultimap<K, V> forward;

    public ReversibleSetMultimapImpl(ReversibleMap<V, K> reverse, SetMultimap<K, V> forward) {
        this.reverse = reverse;
        this.forward = forward;
    }

    @Override
    public ReversibleMap<V, K> reverse() {
        return this.reverse;
    }

    @Override
    public boolean put(K key, V value) {
        K tmp = this.reverse.put(value, key);
        boolean change = tmp == key;
        return change;
    }

    public Set<Map.Entry<K, V>> entries() {
        return this.forward.entries();
    }

    @Override
    public Set<V> get(K key) {
        Set result = this.forward.get(key);
        return result;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean result = this.forward.containsEntry(key, value);
        if (result) {
            this.reverse.remove(value);
        }
        return result;
    }

    @Override
    public Set<V> removeAll(Object key) {
        LinkedHashSet result = new LinkedHashSet(this.forward.get(key));
        result.forEach(this.reverse::remove);
        return result;
    }

    @Override
    public void clear() {
        this.reverse.clear();
    }

    public int hashCode() {
        return this.forward.hashCode();
    }

    public boolean equals(Object arg) {
        return this.forward.equals(arg);
    }
}

