/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collections.utils;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class StreamUtils {
    public static <T> Stream<List<T>> mapToBatch(Stream<T> stream, final int batchSize) {
        final Iterator baseIt = stream.iterator();
        AbstractIterator it = new AbstractIterator<List<T>>(){

            protected List<T> computeNext() {
                ArrayList items = new ArrayList(batchSize);
                for (int i = 0; baseIt.hasNext() && i < batchSize; ++i) {
                    Object item = baseIt.next();
                    items.add(item);
                }
                ArrayList r = items.isEmpty() ? (List)this.endOfData() : items;
                return r;
            }
        };
        Iterable tmp = () -> StreamUtils.lambda$mapToBatch$0((Iterator)it);
        Stream result = Streams.stream(tmp);
        result.onClose(() -> stream.close());
        return result;
    }

    public static <T> Stream<T> appendAction(Stream<? extends T> stream, Runnable runnable) {
        Stream<Object> result = Stream.concat(stream, Stream.of(null).filter(x -> {
            runnable.run();
            return false;
        }));
        return result;
    }

    public static <S, X> Stream<X> stream(BiConsumer<S, Consumer<X>> fn, S baseSolution) {
        ArrayList result = new ArrayList();
        fn.accept(baseSolution, item -> result.add(item));
        return result.stream();
    }

    private static /* synthetic */ Iterator lambda$mapToBatch$0(Iterator it) {
        return it;
    }
}

