/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedFile {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedFile.class);
    public boolean trim = true;
    private final File file;

    public ExtendedFile(File file) {
        this.file = file;
        logger.trace("File exists? " + file.exists());
    }

    public String readContentLogException() {
        try {
            return this.readContent();
        }
        catch (FileNotFoundException e) {
            logger.error("File could not be found " + this.file.toString(), (Throwable)e);
            return "null";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readContent() throws FileNotFoundException {
        StringBuffer buf = new StringBuffer();
        try (Scanner scanner = new Scanner(this.file);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                line = this.readOperations(line);
                line = line + "\n";
                buf.append(line);
            }
        }
        return buf.toString();
    }

    public List<String> readAsListLogException() {
        try {
            return this.readAsList();
        }
        catch (FileNotFoundException e) {
            logger.error("File could not be found " + this.file.toString(), (Throwable)e);
            return new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readAsList() throws FileNotFoundException {
        ArrayList<String> list = new ArrayList<String>();
        try (Scanner scanner = new Scanner(this.file);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                line = this.readOperations(line);
                list.add(line);
            }
        }
        return list;
    }

    private String readOperations(String line) {
        line = this.trim ? line.trim() : line;
        return line;
    }

    public void writeFile(String content) throws IOException {
        FileWriter fw = new FileWriter(this.file, false);
        fw.write(content);
        fw.flush();
    }
}

