/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.aksw.commons.util.URLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files {
    private static final Logger logger = LoggerFactory.getLogger(Files.class);

    public static void createFile(File file, String content) throws IOException {
        Files.writeToFile(file, content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String content, boolean append) throws IOException {
        try (FileWriter fw = new FileWriter(file, append);){
            fw.write(content);
            fw.flush();
        }
    }

    public static String readContent(File file) throws IOException {
        return URLHelper.readContent(file.toURI().toURL());
    }

    public static void mkdir(File path) {
        if (!path.exists()) {
            path.mkdirs();
            logger.info("created path: " + path);
        }
    }
}

