/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.jdbc;

import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.aksw.commons.util.jdbc.ForeignKey;
import org.aksw.commons.util.jdbc.Index;
import org.aksw.commons.util.jdbc.JdbcUtils;
import org.aksw.commons.util.jdbc.PrimaryKey;
import org.aksw.commons.util.jdbc.Relation;

public class Schema {
    private Map<String, Relation> relations;
    private Map<String, PrimaryKey> primaryKeys;
    private Multimap<String, ForeignKey> foreignKeys;
    private Multimap<String, Index> indexes;

    public Schema(Map<String, Relation> relations, Map<String, PrimaryKey> primaryKeys, Multimap<String, ForeignKey> foreignKeys, Multimap<String, Index> indexes) {
        this.relations = relations;
        this.primaryKeys = primaryKeys;
        this.foreignKeys = foreignKeys;
        this.indexes = indexes;
    }

    public Map<String, Relation> getRelations() {
        return this.relations;
    }

    public Map<String, PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public Multimap<String, ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public Multimap<String, Index> getIndexes() {
        return this.indexes;
    }

    public static Schema create(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        String schema = conn.getSchema();
        DatabaseMetaData meta = conn.getMetaData();
        Schema result = Schema.create(meta, catalog, schema, null);
        return result;
    }

    public static Schema create(Connection conn, String schema, Iterable<String> tableNames) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        Schema result = Schema.create(meta, catalog, schema, tableNames);
        return result;
    }

    public static Schema create(DatabaseMetaData meta, String catalog, String schema, Iterable<String> tableNames) throws SQLException {
        if (tableNames == null) {
            tableNames = JdbcUtils.fetchRelationNames(meta, catalog);
        }
        Map<String, Relation> relations = JdbcUtils.fetchColumns(meta, catalog, schema, tableNames);
        Map<String, PrimaryKey> primaryKeys = JdbcUtils.fetchPrimaryKeys(meta, catalog, schema, tableNames);
        Multimap<String, ForeignKey> foreignKeys = JdbcUtils.fetchForeignKeys(meta, catalog, schema, tableNames);
        Set<String> tNames = relations.keySet();
        Multimap<String, Index> indexes = JdbcUtils.fetchIndexes(meta, catalog, schema, tNames, true);
        Schema result = new Schema(relations, primaryKeys, foreignKeys, indexes);
        return result;
    }

    public static Schema create(DatabaseMetaData meta, String catalog) throws SQLException {
        Schema result = Schema.create(meta, catalog, null, null);
        return result;
    }

    public static Schema createSchema(DataSource dataSource) throws SQLException {
        Schema result;
        try (Connection conn = dataSource.getConnection();){
            result = Schema.create(conn);
        }
        return result;
    }
}

