/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.aksw.commons.util.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtils.class);

    public static Object forceInvoke(Method m, Object[] args) {
        return ClassUtils.forceInvoke(null, m, args);
    }

    public static Object forceInvoke(Object o, Method m, Object[] args) {
        boolean isAccessible = m.isAccessible();
        m.setAccessible(true);
        try {
            Object object = m.invoke(o, args);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            m.setAccessible(isAccessible);
        }
    }

    public static Integer getDistance(Class<?> given, Class<?> there) {
        int result = there.isInterface() ? ClassUtils._getDistanceInterface(given, there, 0) : ClassUtils._getDistanceClass(given, there);
        return result == Integer.MAX_VALUE ? null : Integer.valueOf(result);
    }

    private static int _getDistanceClass(Class<?> given, Class<?> there) {
        int distance = 0;
        do {
            if (given == there) {
                return distance;
            }
            ++distance;
        } while ((given = given.getSuperclass()) != null);
        return Integer.MAX_VALUE;
    }

    private static int _getDistanceInterface(Class<?> given, Class<?> there, int depth) {
        if (given == there) {
            return depth;
        }
        ++depth;
        int result = Integer.MAX_VALUE;
        for (Class<?> item : given.getInterfaces()) {
            result = Math.min(result, ClassUtils._getDistanceInterface(item, there, depth));
        }
        Class<?> superClass = given.getSuperclass();
        if (superClass != null) {
            result = Math.min(result, ClassUtils._getDistanceInterface(superClass, there, depth));
        }
        return result;
    }

    public static List<Class<?>> getTypeSignatureList(Object[] args) {
        ArrayList result = new ArrayList(args.length);
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            result.add(arg == null ? null : arg.getClass());
        }
        return result;
    }

    public static Class<?>[] getTypeSignature(Object[] args) {
        Class[] result = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            result[i] = arg == null ? null : arg.getClass();
        }
        return result;
    }

    public static Integer[] getDistance(Class<?>[] a, Class<?>[] b) {
        int n = Math.min(a.length, b.length);
        Integer[] result = new Integer[n];
        for (int i = 0; i < n; ++i) {
            Class<?> given = a[i];
            result[i] = given == null ? Integer.valueOf(0) : ClassUtils.getDistance(given, b[i]);
        }
        return result;
    }

    public static Integer[] getDistance(Class<?> ra, Class<?> rb, Class<?>[] a, Class<?>[] b) {
        int n = Math.min(a.length, b.length);
        Integer[] result = new Integer[n + 1];
        result[0] = ClassUtils.getDistance(rb, ra);
        for (int i = 0; i < n; ++i) {
            Integer d;
            result[i + 1] = d = ClassUtils.getDistance(a[i], b[i]);
        }
        return result;
    }

    public static Integer getRelation(Integer[] a, Integer[] b) {
        boolean hasGreater = false;
        boolean hasLess = false;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null || b[i] == null) {
                throw new NullPointerException();
            }
            int d = a[i] - b[i];
            if (d > 0) {
                hasGreater = true;
                continue;
            }
            if (d >= 0) continue;
            hasLess = true;
        }
        if (hasGreater && hasLess) {
            return null;
        }
        if (hasGreater) {
            return 1;
        }
        if (hasLess) {
            return -1;
        }
        return 0;
    }

    public static List<Method> getAllNonOverriddenMethods(Class<?> clazz) {
        List<Method> result = ClassUtils.getAllNonOverriddenMethods(clazz, null);
        return result;
    }

    public static List<Method> getAllNonOverriddenMethods(Class<?> clazz, String name) {
        ArrayList<Method> result = new ArrayList<Method>();
        HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                MethodSignature signature;
                if (name != null && !method.getName().equals(name) || signatures.contains(signature = new MethodSignature(method))) continue;
                result.add(method);
                signatures.add(signature);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }
}

