/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.backports.syntaxtransform;

import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.backports.syntaxtransform.ElementTransformCopyBase;
import org.aksw.jena_sparql_api.backports.syntaxtransform.NodeTransformSubst;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;

public class ElementTransformSubst
extends ElementTransformCopyBase {
    private final NodeTransform nodeTransform;

    public ElementTransformSubst(Map<Var, ? extends Node> mapping) {
        this(new NodeTransformSubst(mapping));
    }

    public ElementTransformSubst(NodeTransform nodeTransform) {
        this.nodeTransform = nodeTransform;
    }

    @Override
    public Element transform(ElementData el) {
        List vars = el.getVars();
        List bindings = el.getRows();
        List newVars = NodeTransformLib.transformVars((NodeTransform)this.nodeTransform, (List)vars);
        ElementData result = new ElementData();
        newVars.forEach(v -> result.add(v));
        bindings.forEach(b -> result.add(NodeTransformLib.transform((Binding)b, (NodeTransform)this.nodeTransform)));
        return result;
    }

    @Override
    public Element transform(ElementFilter el, Expr expr2) {
        Expr expr = NodeTransformLib.transform((NodeTransform)this.nodeTransform, (Expr)expr2);
        ElementFilter result = expr.equals((Object)expr2) ? el : new ElementFilter(expr);
        return result;
    }

    @Override
    public Element transform(ElementTriplesBlock el) {
        ElementTriplesBlock etb = new ElementTriplesBlock();
        boolean changed = false;
        for (Triple t : el.getPattern()) {
            Triple t2 = this.transform(t);
            changed = changed || t != t2;
            etb.addTriple(t2);
        }
        if (changed) {
            return etb;
        }
        return el;
    }

    @Override
    public Element transform(ElementPathBlock el) {
        ElementPathBlock epb = new ElementPathBlock();
        boolean changed = false;
        for (TriplePath p : el.getPattern()) {
            TriplePath p2 = this.transform(p);
            changed = changed || p != p2;
            epb.addTriplePath(p2);
        }
        if (changed) {
            return epb;
        }
        return el;
    }

    private TriplePath transform(TriplePath path) {
        Node s = path.getSubject();
        Node s1 = this.transform(s);
        Node o = path.getObject();
        Node o1 = this.transform(o);
        if (path.isTriple()) {
            Node p = path.getPredicate();
            Node p1 = this.transform(p);
            if (s == s1 && p == p1 && o == o1) {
                return path;
            }
            return new TriplePath(Triple.create((Node)s1, (Node)p1, (Node)o1));
        }
        if (s == s1 && o == o1) {
            return path;
        }
        return new TriplePath(s1, path.getPath(), o1);
    }

    private Triple transform(Triple triple) {
        Node s = triple.getSubject();
        Node s1 = this.transform(s);
        Node p = triple.getPredicate();
        Node p1 = this.transform(p);
        Node o = triple.getObject();
        Node o1 = this.transform(o);
        if (s == s1 && p == p1 && o == o1) {
            return triple;
        }
        return Triple.create((Node)s1, (Node)p1, (Node)o1);
    }

    private Node transform(Node n) {
        return (Node)this.nodeTransform.apply((Object)n);
    }
}

