/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.backports.syntaxtransform;

import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;

public class TransformElementLib {
    public static Var applyVar(Var v, ExprTransform exprTransform) {
        if (exprTransform == null) {
            return v;
        }
        ExprVar expr = new ExprVar(v);
        Expr e = exprTransform.transform(expr);
        if (e instanceof ExprVar) {
            return ((ExprVar)e).asVar();
        }
        throw new InternalErrorException("Managed to turn a variable " + v + " into " + e);
    }

    public static Node apply(Node n, ExprTransform exprTransform) {
        if (exprTransform == null) {
            return n;
        }
        Expr e = null;
        if (Var.isVar((Node)n)) {
            Var v = Var.alloc((Node)n);
            ExprVar expr = new ExprVar(v);
            e = exprTransform.transform(expr);
        } else {
            NodeValue nv = NodeValue.makeNode((Node)n);
            e = exprTransform.transform(nv);
        }
        if (e instanceof ExprVar) {
            return ((ExprVar)e).asVar();
        }
        if (e instanceof NodeValue) {
            return ((NodeValue)e).asNode();
        }
        throw new InternalErrorException("Managed to turn a node " + n + " into " + e);
    }
}

