/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.util;

import java.util.function.Function;
import java.util.stream.Stream;

public class RewriteUtils {
    public static <T> T transformUntilNoChange(T after, Function<T, T> fn) {
        T before;
        while (!(before = after).equals(after = fn.apply(before))) {
        }
        return after;
    }

    public static <T, C> Stream<T> exhaustiveRewrite(T baseItem, Function<T, Stream<T>> reductions) {
        Stream result = Stream.of(baseItem).flatMap(item -> {
            boolean[] empty = new boolean[]{true};
            Stream nestedItems = ((Stream)reductions.apply(item)).peek(i -> {
                empty[0] = false;
            }).flatMap(c -> {
                Stream<Object> r = RewriteUtils.exhaustiveRewrite(c, reductions);
                return r;
            });
            Stream<Object> s = Stream.concat(nestedItems, Stream.of(item).filter(x -> empty[0]));
            return s;
        });
        return result;
    }

    public static <T, C, X extends Comparable<X>> T exhaustiveRewrite(T item, Function<T, Stream<T>> reductions, Function<T, X> cost) {
        Stream<T> stream = RewriteUtils.exhaustiveRewrite(item, reductions);
        T result = stream.min((a, b) -> {
            Comparable ca = (Comparable)cost.apply(a);
            Comparable cb = (Comparable)cost.apply(b);
            int r = ca.compareTo(cb);
            return r;
        }).orElse(null);
        return result;
    }

    public static <T, C> Stream<T> greedyRewrite(T item, Function<T, Stream<T>> reductions) {
        return Stream.of(item).map(i -> RewriteUtils.greedyRewriteCore(item, reductions));
    }

    public static <T, C> T greedyRewriteCore(T item, Function<T, Stream<T>> reductions) {
        Object tmp;
        T result = item;
        while ((tmp = reductions.apply(result).findFirst().orElse(null)) != null) {
            result = tmp;
        }
        return result;
    }
}

