/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.util.collection;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.commons.collections.cache.IndexBasedIterator;
import org.aksw.jena_sparql_api.util.collection.RangedSupplierLazyLoadingListCache;
import org.aksw.jena_sparql_api.utils.IteratorClosable;
import org.apache.jena.util.iterator.ClosableIterator;

public class LazyLoadingCachingListIterator<T>
extends AbstractIterator<T>
implements ClosableIterator<T> {
    protected Range<Long> canonicalRequestRange;
    protected long offset;
    protected RangeMap<Long, RangedSupplierLazyLoadingListCache.CacheEntry<T>> rangeMap;
    protected Function<Range<Long>, Stream<T>> delegate;
    protected boolean usedDelegate;
    protected transient ClosableIterator<T> currentIterator;

    public LazyLoadingCachingListIterator(Range<Long> canonicalRequestRange, RangeMap<Long, RangedSupplierLazyLoadingListCache.CacheEntry<T>> rangeMap, Function<Range<Long>, Stream<T>> delegate) {
        this.canonicalRequestRange = canonicalRequestRange;
        this.rangeMap = rangeMap;
        this.delegate = delegate;
        this.offset = (Long)canonicalRequestRange.lowerEndpoint();
        this.usedDelegate = false;
    }

    public void close() {
        this.currentIterator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T computeNext() {
        Object result;
        while (true) {
            boolean isOffsetInRequestRange;
            if (!(isOffsetInRequestRange = this.canonicalRequestRange.contains((Comparable)Long.valueOf(this.offset)))) {
                this.currentIterator.close();
                result = this.endOfData();
                break;
            }
            if (this.currentIterator == null) {
                Map.Entry e;
                RangeMap<Long, RangedSupplierLazyLoadingListCache.CacheEntry<T>> rangeMap = this.rangeMap;
                synchronized (rangeMap) {
                    e = this.rangeMap.getEntry((Comparable)Long.valueOf(this.offset));
                }
                if (e == null) {
                    if (this.delegate != null && !this.usedDelegate) {
                        Range r = Range.atLeast((Comparable)Long.valueOf(this.offset)).intersection(this.canonicalRequestRange);
                        Stream<T> stream = this.delegate.apply((Range<Long>)r);
                        this.currentIterator = new IteratorClosable(stream.iterator(), stream::close);
                        this.usedDelegate = true;
                        continue;
                    }
                    result = this.endOfData();
                    break;
                }
                RangedSupplierLazyLoadingListCache.CacheEntry ce = (RangedSupplierLazyLoadingListCache.CacheEntry)e.getValue();
                Range<Long> pageRange = ce.range;
                long offsetWithinPage = this.offset - (Long)pageRange.lowerEndpoint();
                IndexBasedIterator tmp = new IndexBasedIterator(ce.cache, (int)offsetWithinPage);
                this.currentIterator = new IteratorClosable(tmp);
                if (this.currentIterator.hasNext()) continue;
                result = this.endOfData();
                this.currentIterator.close();
                break;
            }
            if (this.currentIterator.hasNext()) {
                result = this.currentIterator.next();
                ++this.offset;
                break;
            }
            this.currentIterator.close();
            this.currentIterator = null;
        }
        return (T)result;
    }
}

