/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.util.collection;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Stream;
import org.aksw.commons.collections.cache.Cache;
import org.aksw.commons.collections.cache.CacheImpl;
import org.aksw.jena_sparql_api.util.collection.CacheRangeInfo;
import org.aksw.jena_sparql_api.util.collection.LazyLoadingCachingListIterator;
import org.aksw.jena_sparql_api.util.collection.RangeCostModel;
import org.aksw.jena_sparql_api.util.collection.RangedSupplier;
import org.aksw.jena_sparql_api.util.collection.RangedSupplierDelegated;
import org.aksw.jena_sparql_api.util.collection.StreamUtils;
import org.aksw.jena_sparql_api.utils.RangeUtils;

public class RangedSupplierLazyLoadingListCache<T>
extends RangedSupplierDelegated<Long, T>
implements CacheRangeInfo<Long> {
    protected ExecutorService executorService;
    protected Range<Long> cacheRange;
    protected RangeCostModel costModel;
    protected RangeMap<Long, CacheEntry<T>> rangesToData;
    protected Long dataThreshold = null;

    public static Range<Long> normalize(Range<Long> range) {
        range = RangeUtils.startFromZero(range);
        Range result = range.canonical(DiscreteDomain.longs());
        return result;
    }

    @Override
    public boolean isCached(Range<Long> range) {
        boolean result;
        RangeMap subRangeMap;
        Map x;
        range = RangedSupplierLazyLoadingListCache.normalize(range);
        if (this.dataThreshold != null) {
            Range dataRange = Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)this.dataThreshold);
            range = range.intersection(dataRange);
        }
        if ((x = (subRangeMap = this.rangesToData.subRangeMap(range)).asMapOfRanges()).size() == 1) {
            Map.Entry entry = x.entrySet().iterator().next();
            CacheEntry ce = (CacheEntry)entry.getValue();
            boolean isEnclosing = ce.range.encloses(range);
            boolean isDataComplete = ce.cache.isComplete();
            result = isEnclosing && isDataComplete;
        } else {
            result = false;
        }
        return result;
    }

    public RangedSupplierLazyLoadingListCache(ExecutorService executorService, RangedSupplier<Long, T> delegate) {
        this(executorService, delegate, (Range<Long>)Range.atLeast((Comparable)Long.valueOf(0L)));
    }

    public RangedSupplierLazyLoadingListCache(ExecutorService executorService, RangedSupplier<Long, T> delegate, Range<Long> range) {
        this(executorService, delegate, range, null);
    }

    public RangedSupplierLazyLoadingListCache(ExecutorService executorService, RangedSupplier<Long, T> delegate, Range<Long> cacheRange, RangeCostModel costModel) {
        super(delegate);
        this.executorService = executorService;
        this.cacheRange = cacheRange;
        this.rangesToData = TreeRangeMap.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<T> apply(Range<Long> range) {
        Stream result;
        if ((range = RangedSupplierLazyLoadingListCache.normalize(range)).isEmpty()) {
            result = Stream.empty();
        } else {
            RangeMap<Long, CacheEntry<T>> rangeMap = this.rangesToData;
            synchronized (rangeMap) {
                Range part;
                Range lastGap;
                Range lookupRange = range.intersection(this.cacheRange);
                RangeMap subMap = this.rangesToData.subRangeMap(lookupRange);
                ArrayList<RangeInfo<T>> rangeInfos = new ArrayList<RangeInfo<T>>();
                Long offset = (Long)range.lowerEndpoint();
                for (Map.Entry e : subMap.asMapOfRanges().entrySet()) {
                    Range eRange = (Range)e.getKey();
                    Cache cache = ((CacheEntry)e.getValue()).cache;
                    long ele = (Long)eRange.lowerEndpoint();
                    if (ele > offset) {
                        Range gap = Range.closedOpen((Comparable)offset, (Comparable)Long.valueOf(ele));
                        if (!gap.isEmpty()) {
                            rangeInfos.add(new RangeInfo((Range<Long>)gap, true, null));
                        }
                    } else {
                        rangeInfos.add(new RangeInfo((Range<Long>)eRange, false, cache));
                    }
                    offset = eRange.hasUpperBound() ? (Long)eRange.upperEndpoint() : null;
                }
                if (offset != null && !(lastGap = (part = Range.atLeast((Comparable)offset)).intersection(lookupRange)).isEmpty()) {
                    rangeInfos.add(new RangeInfo((Range<Long>)lastGap, true, null));
                }
                this.fetchGaps(subMap, rangeInfos);
            }
            LazyLoadingCachingListIterator<T> it = new LazyLoadingCachingListIterator<T>(range, this.rangesToData, (Function)this.delegate);
            result = StreamUtils.stream(it);
        }
        return result;
    }

    public void fetchGaps(RangeMap<Long, CacheEntry<T>> subMap, List<RangeInfo<T>> rangeInfos) {
        for (RangeInfo<T> rangeInfo : rangeInfos) {
            if (!rangeInfo.isGap) continue;
            this.fetchGap(subMap, rangeInfo.range);
        }
    }

    public void fetchGap(RangeMap<Long, CacheEntry<T>> subMap, Range<Long> range) {
        ArrayList cacheData = new ArrayList();
        CacheImpl cache = new CacheImpl(cacheData);
        CacheEntry cacheEntry = new CacheEntry(range, cache);
        subMap.put(range, cacheEntry);
        Stream stream = (Stream)((RangedSupplier)this.delegate).apply(range);
        Iterator ci = stream.iterator();
        long maxCacheSize = this.cacheRange.hasUpperBound() ? (Long)this.cacheRange.upperEndpoint() : Long.MAX_VALUE;
        Runnable task = () -> this.lambda$fetchGap$0(ci, maxCacheSize, (Cache)cache, cacheData, stream);
        this.executorService.submit(task);
    }

    public String toString() {
        return "RangedSupplierLazyLoadingListCache [cacheRange=" + this.cacheRange + ", costModel=" + this.costModel + ", rangesToData=" + this.rangesToData + ", dataThreshold=" + this.dataThreshold + ", executorService=" + this.executorService + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$fetchGap$0(Iterator ci, long maxCacheSize, Cache cache, List cacheData, Stream stream) {
        try {
            boolean hasMoreData;
            long i = 0L;
            int notificationInterval = 100;
            boolean isOk = true;
            boolean isTooBig = false;
            while ((hasMoreData = ci.hasNext()) && !(isTooBig = i >= maxCacheSize) && (isOk = !cache.isAbandoned() && !Thread.interrupted())) {
                Object binding = ci.next();
                cacheData.add(binding);
                if (++i % (long)notificationInterval != 0L) continue;
                Cache cache2 = cache;
                synchronized (cache2) {
                    cache.notifyAll();
                }
            }
            if (!hasMoreData) {
                this.dataThreshold = this.dataThreshold == null || i < this.dataThreshold ? i : this.dataThreshold;
            }
            if (isOk) {
                cache.setComplete();
            }
            if (isTooBig) {
                cache.setComplete();
            }
        }
        catch (Exception e) {
            cache.setAbandoned();
            throw new RuntimeException(e);
        }
        finally {
            Cache cache3 = cache;
            synchronized (cache3) {
                cache.notifyAll();
            }
            stream.close();
        }
    }

    static class RangeInfo<T> {
        Range<Long> range;
        boolean isGap;
        Cache<T> cache;

        public RangeInfo(Range<Long> range, boolean isGap, Cache<T> cache) {
            this.range = range;
            this.isGap = isGap;
            this.cache = cache;
        }

        public String toString() {
            return "[" + this.range + ", " + (this.isGap ? "gap" : "data") + "]";
        }
    }

    static class CacheEntry<T> {
        Range<Long> range;
        Cache<T> cache;

        public CacheEntry(Range<Long> range, Cache<T> cache) {
            this.range = range;
            this.cache = cache;
        }
    }
}

