/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.util.collection;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.List;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.util.collection.RangedSupplier;

public class RangedSupplierList<T>
implements RangedSupplier<Long, T> {
    protected List<T> items;

    public RangedSupplierList(List<T> items) {
        this.items = items;
    }

    @Override
    public Stream<T> apply(Range<Long> range) {
        Range validRange = Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(this.items.size()));
        Range effectiveRange = range.intersection(validRange).canonical(DiscreteDomain.longs());
        List<T> subList = this.items.subList(((Long)effectiveRange.lowerEndpoint()).intValue(), ((Long)effectiveRange.upperEndpoint()).intValue());
        return subList.stream();
    }

    public String toString() {
        return "StaticListItemSupplier [items=" + this.items + "]";
    }
}

