/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.util.collection;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.util.collection.RangedSupplier;
import org.aksw.jena_sparql_api.util.collection.RangedSupplierDelegated;
import org.aksw.jena_sparql_api.utils.RangeUtils;

public class RangedSupplierSubRange<I extends Comparable<I>, T>
extends RangedSupplierDelegated<I, T> {
    protected Range<I> subRange;
    protected DiscreteDomain<I> domain;
    protected BiFunction<I, Long, I> addition;

    public RangedSupplierSubRange(RangedSupplier<I, T> delegate, Range<I> subRange, DiscreteDomain<I> domain, BiFunction<I, Long, I> addition) {
        super(delegate);
        this.subRange = subRange;
        this.domain = domain;
        this.addition = addition;
    }

    @Override
    public Stream<T> apply(Range<I> rawRequestRange) {
        Range<I> effectiveRange = RangeUtils.makeAbsolute(this.subRange, rawRequestRange, this.domain, this.addition);
        Stream result = (Stream)((RangedSupplier)this.delegate).apply(effectiveRange);
        return result;
    }

    public static <O> RangedSupplierSubRange<Long, O> create(RangedSupplier<Long, O> subRangeSupplier, Range<Long> subRange) {
        RangedSupplierSubRange<Long, O> result = new RangedSupplierSubRange<Long, O>(subRangeSupplier, subRange, DiscreteDomain.longs(), (a, b) -> a + b);
        return result;
    }
}

