/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.util.sparql.syntax.path;

import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathVisitor;

public class PathVisitorWalker
implements PathVisitor {
    protected final PathVisitor proc;
    protected final PathVisitor beforeVisitor;
    protected final PathVisitor afterVisitor;

    protected PathVisitorWalker(PathVisitor visitor, PathVisitor beforeVisitor, PathVisitor afterVisitor) {
        this.proc = visitor;
        this.beforeVisitor = beforeVisitor;
        this.afterVisitor = afterVisitor;
    }

    private void before(Path path) {
        if (this.beforeVisitor != null) {
            path.visit(this.beforeVisitor);
        }
    }

    private void after(Path path) {
        if (this.afterVisitor != null) {
            path.visit(this.afterVisitor);
        }
    }

    public void visit(P_Link path) {
        this.before((Path)path);
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_ReverseLink path) {
        this.before((Path)path);
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_NegPropSet path) {
        this.before((Path)path);
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_Inverse path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_Mod path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_FixedLength path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_Distinct path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_Multi path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_Shortest path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_ZeroOrOne path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_ZeroOrMore1 path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_ZeroOrMoreN path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_OneOrMore1 path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_OneOrMoreN path) {
        this.before((Path)path);
        if (path.getSubPath() != null) {
            path.getSubPath().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_Alt path) {
        this.before((Path)path);
        if (path.getLeft() != null) {
            path.getLeft().visit((PathVisitor)this);
        }
        if (path.getRight() != null) {
            path.getRight().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }

    public void visit(P_Seq path) {
        this.before((Path)path);
        if (path.getLeft() != null) {
            path.getLeft().visit((PathVisitor)this);
        }
        if (path.getRight() != null) {
            path.getRight().visit((PathVisitor)this);
        }
        this.proc.visit(path);
        this.after((Path)path);
    }
}

