/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;

public class BindingUtils {
    public static Binding transformKeys(Binding binding, NodeTransform transform) {
        Iterator it = binding.vars();
        BindingHashMap result = new BindingHashMap();
        while (it.hasNext()) {
            Var o = (Var)it.next();
            Node node = binding.get(o);
            Var n = (Var)transform.apply((Object)o);
            result.add(n, node);
        }
        return result;
    }

    public static Map<Var, Node> toMap(Binding binding) {
        HashMap<Var, Node> result = new HashMap<Var, Node>();
        Iterator it = binding.vars();
        while (it.hasNext()) {
            Var v = (Var)it.next();
            Node n = binding.get(v);
            result.put(v, n);
        }
        return result;
    }

    public static List<Binding> addRowIds(Collection<Binding> bindings, Var rowId) {
        ArrayList<Binding> result = new ArrayList<Binding>(bindings.size());
        long i = 0L;
        for (Binding parent : bindings) {
            BindingHashMap b = new BindingHashMap(parent);
            Node node = NodeValue.makeInteger((long)i).asNode();
            b.add(rowId, node);
            ++i;
        }
        return result;
    }

    public static Binding rename(Binding binding, Map<Var, Var> varMap) {
        BindingHashMap result = new BindingHashMap();
        Iterator itVars = binding.vars();
        while (itVars.hasNext()) {
            Var sourceVar = (Var)itVars.next();
            Node node = binding.get(sourceVar);
            Var targetVar = varMap.get(sourceVar);
            if (targetVar == null) {
                targetVar = sourceVar;
            }
            result.add(targetVar, node);
        }
        return result;
    }
}

