/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.ExprUtils;
import org.aksw.jena_sparql_api.utils.FilterUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;

public class CnfUtils {
    public static <T extends ExprFunction2> T normalize(T expr) {
        Expr a = expr.getArg1();
        Expr b = expr.getArg2();
        T result = a.isConstant() && b.isVariable() ? expr.copy(b, a) : expr;
        return result;
    }

    public static Map.Entry<Var, Node> extractEquality(Collection<? extends Expr> clause) {
        Expr expr;
        AbstractMap.SimpleEntry<Var, Node> result = null;
        if (clause.size() == 1 && (expr = clause.iterator().next()) instanceof E_Equals) {
            E_Equals eq = (E_Equals)expr;
            eq = CnfUtils.normalize(eq);
            Expr a = eq.getArg1();
            Expr b = eq.getArg2();
            if (a.isVariable() && b.isConstant()) {
                Var v = a.asVar();
                Node c = b.getConstant().getNode();
                result = new AbstractMap.SimpleEntry<Var, Node>(v, c);
            }
        }
        return result;
    }

    public static <E extends Expr, C extends Collection<? extends E>> Set<C> getEqualityClauses(Iterable<C> cnf) {
        HashSet<Collection> result = new HashSet<Collection>();
        for (Collection clause : cnf) {
            Map.Entry<Var, Node> entry = CnfUtils.extractEquality(clause);
            if (entry == null) continue;
            result.add(clause);
        }
        return result;
    }

    public static Map<Var, Node> getConstants(Iterable<? extends Collection<? extends Expr>> cnf) {
        HashMap<Var, Node> result = new HashMap<Var, Node>();
        HashSet<Var> inconsistent = new HashSet<Var>();
        for (Collection<? extends Expr> collection : cnf) {
            Map.Entry<Var, Node> entry = CnfUtils.extractEquality(collection);
            if (entry == null) continue;
            Var v = entry.getKey();
            Node c = entry.getValue();
            Node o = (Node)result.get(v);
            if (o != null && !o.equals((Object)c) && !inconsistent.contains(v)) {
                inconsistent.add(v);
                result.remove(v);
                continue;
            }
            result.put(v, c);
        }
        return result;
    }

    public static Expr toExpr(Iterable<Set<Expr>> cnf) {
        ExprList exprList = CnfUtils.toExprList(cnf);
        Expr result = ExprUtils.andifyBalanced((Iterable<Expr>)exprList);
        return result;
    }

    public static ExprList toExprList(Iterable<Set<Expr>> cnf) {
        ExprList result = new ExprList();
        for (Set<Expr> clause : cnf) {
            if (clause.equals(ClauseUtils.TRUE)) continue;
            Expr expr = ExprUtils.orifyBalanced(clause);
            result.add(expr);
        }
        return result;
    }

    public static void main(String[] args) {
        String sA = "Select * { ?s ?p ?o . Filter((!(!?a) || ?b) && (?a || ?d && ?b)) . }";
        Query qA = QueryFactory.create((String)sA);
        Op opA = Algebra.compile((Query)qA);
        opA = Algebra.toQuadForm((Op)opA);
        ExprList exprs = FilterUtils.collectExprs(opA, new ExprList());
        Expr expr = ExprUtils.andifyBalanced((Iterable<Expr>)exprs);
        Expr x = CnfUtils.eval(expr);
        System.out.println("HERE: " + x);
        Set<Set<Expr>> cnf = CnfUtils.toSetCnf(expr);
        System.out.println("THERE: " + cnf);
    }

    public static boolean isSubsumedBy(Set<Set<Expr>> cand, Set<Set<Expr>> ref) {
        boolean result = true;
        for (Set<Expr> clause : ref) {
            boolean isContained = cand.contains(clause);
            if (isContained) continue;
            result = false;
            break;
        }
        return result;
    }

    public static Set<Set<Expr>> toSetCnf(ExprList exprs) {
        List<ExprList> clauses = CnfUtils.toClauses(exprs);
        Set<Set<Expr>> cnf = FilterUtils.toSets(clauses);
        return cnf;
    }

    public static Set<Set<Expr>> toSetCnf(Expr expr) {
        Set<Set<Expr>> result;
        if (NodeValue.TRUE.equals((Object)expr)) {
            result = new HashSet<Set<Expr>>();
        } else {
            List<ExprList> clauses = CnfUtils.toClauses(expr);
            result = FilterUtils.toSets(clauses);
        }
        return result;
    }

    public static List<ExprList> toClauses(Expr expr) {
        Expr evaluated = CnfUtils.eval(expr);
        return evaluated == null ? null : CnfUtils.cnfToClauses(Collections.singleton(evaluated));
    }

    public static List<ExprList> toClauses(ExprList exprs) {
        Expr evaluated = CnfUtils.eval(ExprUtils.andifyBalanced((Iterable<Expr>)exprs));
        return evaluated == null ? null : CnfUtils.cnfToClauses(Collections.singleton(evaluated));
    }

    public static List<ExprList> cnfToClauses(Iterable<Expr> exprs) {
        ArrayList<ExprList> result = new ArrayList<ExprList>();
        for (Expr expr : exprs) {
            CnfUtils.collectAnd(expr, result);
        }
        return result;
    }

    public static void collectAnd(Expr expr, List<ExprList> list) {
        if (expr instanceof E_LogicalAnd) {
            E_LogicalAnd e = (E_LogicalAnd)expr;
            CnfUtils.collectAnd(e.getArg1(), list);
            CnfUtils.collectAnd(e.getArg2(), list);
        } else if (expr instanceof E_LogicalOr) {
            ExprList ors = new ExprList();
            CnfUtils.collectOr(expr, ors);
            list.add(ors);
        } else {
            list.add(new ExprList(expr));
        }
    }

    public static void collectOr(Expr expr, ExprList list) {
        if (expr instanceof E_LogicalOr) {
            E_LogicalOr e = (E_LogicalOr)expr;
            CnfUtils.collectOr(e.getArg1(), list);
            CnfUtils.collectOr(e.getArg2(), list);
        } else {
            list.add(expr);
        }
    }

    public static Expr eval(Expr expr) {
        if (expr instanceof ExprFunction) {
            return CnfUtils.handle((ExprFunction)expr);
        }
        return expr;
    }

    public static Expr handle(ExprFunction expr) {
        if (expr instanceof E_LogicalNot) {
            Expr tmp = ((E_LogicalNot)expr).getArg();
            if (!(tmp instanceof ExprFunction)) {
                return expr;
            }
            ExprFunction child = (ExprFunction)tmp;
            ExprFunction newExpr = expr;
            if (child instanceof E_LogicalAnd) {
                newExpr = new E_LogicalOr(CnfUtils.eval((Expr)new E_LogicalNot(child.getArg(1))), CnfUtils.eval((Expr)new E_LogicalNot(child.getArg(2))));
            } else if (child instanceof E_LogicalOr) {
                newExpr = new E_LogicalAnd(CnfUtils.eval((Expr)new E_LogicalNot(child.getArg(1))), CnfUtils.eval((Expr)new E_LogicalNot(child.getArg(2))));
            } else if (child instanceof E_LogicalNot) {
                newExpr = CnfUtils.eval(child.getArg(1));
            } else {
                return expr;
            }
            return CnfUtils.eval((Expr)newExpr);
        }
        if (expr instanceof E_LogicalAnd) {
            return new E_LogicalAnd(CnfUtils.eval(expr.getArg(1)), CnfUtils.eval(expr.getArg(2)));
        }
        if (expr instanceof E_LogicalOr) {
            Expr aa = CnfUtils.eval(expr.getArg(1));
            Expr bb = CnfUtils.eval(expr.getArg(2));
            E_LogicalAnd a = null;
            Expr b = null;
            if (aa instanceof E_LogicalAnd) {
                a = (E_LogicalAnd)aa;
                b = bb;
            } else if (bb instanceof E_LogicalAnd) {
                a = (E_LogicalAnd)bb;
                b = aa;
            }
            if (a == null) {
                return new E_LogicalOr(aa, bb);
            }
            return new E_LogicalAnd(CnfUtils.eval((Expr)new E_LogicalOr(a.getArg(1), b)), CnfUtils.eval((Expr)new E_LogicalOr(a.getArg(2), b)));
        }
        if (expr instanceof E_NotEquals) {
            return new E_LogicalNot(CnfUtils.eval((Expr)new E_Equals(expr.getArg(1), expr.getArg(2))));
        }
        return expr;
    }
}

