/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Quad;

public class DatasetDescriptionUtils {
    public static void mergeInto(DatasetDescription target, DatasetDescription source) {
        target.addAllDefaultGraphURIs((Collection)source.getDefaultGraphURIs());
        target.addAllNamedGraphURIs((Collection)source.getNamedGraphURIs());
    }

    public static Node getSingleDefaultGraph(DatasetDescription datasetDescription) {
        String str = DatasetDescriptionUtils.getSingleDefaultGraphUri(datasetDescription);
        Node result = NodeFactory.createURI((String)str);
        return result;
    }

    public static String getSingleDefaultGraphUri(DatasetDescription datasetDescription) {
        String result;
        if (datasetDescription == null) {
            result = Quad.defaultGraphIRI.getURI();
        } else {
            List dgus = datasetDescription.getDefaultGraphURIs();
            result = datasetDescription != null && dgus.size() == 1 ? (String)dgus.iterator().next() : null;
        }
        return result;
    }

    public static DatasetDescription createDefaultGraph(Node defaultGraph) {
        DatasetDescription result = DatasetDescriptionUtils.createDefaultGraph(defaultGraph.getURI());
        return result;
    }

    public static DatasetDescription createDefaultGraph(String defaultGraph) {
        DatasetDescription result = new DatasetDescription();
        result.addDefaultGraphURI(defaultGraph);
        return result;
    }

    public static String toString(DatasetDescription datasetDescription) {
        String result = datasetDescription == null ? null : "[defaultGraphs = " + Joiner.on((String)", ").join((Iterable)datasetDescription.getDefaultGraphURIs()) + "][namedGraphs = " + Joiner.on((String)", ").join((Iterable)datasetDescription.getNamedGraphURIs()) + "]";
        return result;
    }
}

