/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import org.aksw.commons.collections.diff.Diff;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Quad;

public class DatasetGraphUtils {
    public static void addAll(DatasetGraph target, DatasetGraph source) {
        Iterator it = source.find();
        DatasetGraphUtils.addAll(target, it);
    }

    public static void addAll(DatasetGraph datasetGraph, Iterable<? extends Quad> items) {
        DatasetGraphUtils.addAll(datasetGraph, items.iterator());
    }

    public static void addAll(DatasetGraph datasetGraph, Iterator<? extends Quad> it) {
        while (it.hasNext()) {
            Quad q = it.next();
            datasetGraph.add(q);
        }
    }

    public static DatasetGraph clone(DatasetGraph datasetGraph) {
        Iterator it = datasetGraph.find();
        DatasetGraph clone = DatasetGraphFactory.createGeneral();
        DatasetGraphUtils.addAll(clone, it);
        return clone;
    }

    public static Map<Node, DatasetGraph> mergeInPlace(Map<Node, DatasetGraph> result, Map<Node, DatasetGraph> other) {
        for (Map.Entry<Node, DatasetGraph> entry : other.entrySet()) {
            Node node = entry.getKey();
            DatasetGraph otherGraph = entry.getValue();
            DatasetGraph graph = result.get(node);
            if (graph == null) {
                graph = DatasetGraphFactory.createGeneral();
                result.put(node, graph);
            }
            DatasetGraphUtils.addAll(graph, otherGraph);
        }
        return result;
    }

    public static Diff<DatasetGraph> wrapDiffDatasetGraph(Diff<? extends Iterable<? extends Quad>> diff) {
        DatasetGraph added = DatasetGraphFactory.createGeneral();
        DatasetGraph removed = DatasetGraphFactory.createGeneral();
        DatasetGraphUtils.addAll(added, (Iterable)diff.getAdded());
        DatasetGraphUtils.addAll(removed, (Iterable)diff.getRemoved());
        Diff result = new Diff((Object)added, (Object)removed, null);
        return result;
    }

    public static void write(PrintStream out, DatasetGraph dg) {
        Dataset ds = DatasetFactory.wrap((DatasetGraph)dg);
        Model dm = ds.getDefaultModel();
        if (!dm.isEmpty()) {
            out.println("Begin of Default model -----------------------");
            dm.write((OutputStream)out, "TURTLE");
            out.println("End of Default model -----------------------");
        }
        Iterator it = ds.listNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            Model model = ds.getNamedModel(name);
            System.out.println("Begin of " + name + " -----------------------");
            model.write((OutputStream)out, "TURTLE");
            System.out.println("End of " + name + " -----------------------");
        }
    }
}

