/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MapUtils;
import org.aksw.jena_sparql_api.utils.CnfUtils;
import org.aksw.jena_sparql_api.utils.ElementTransformSubst2;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.apache.jena.sparql.syntax.syntaxtransform.ExprTransformNodeElement;

public class ElementUtils {
    public static ElementTriplesBlock createElement(Triple triple) {
        BasicPattern bgp = new BasicPattern();
        bgp.add(triple);
        ElementTriplesBlock result = new ElementTriplesBlock(bgp);
        return result;
    }

    public static Element createElement(Quad quad) {
        ElementTriplesBlock tripleEl = ElementUtils.createElement(quad.asTriple());
        ElementTriplesBlock result = Quad.isDefaultGraph((Node)quad.getGraph()) ? tripleEl : new ElementNamedGraph(quad.getGraph(), (Element)tripleEl);
        return result;
    }

    public static ElementPathBlock createElement(TriplePath triplePath) {
        ElementPathBlock result = new ElementPathBlock();
        result.addTriplePath(triplePath);
        return result;
    }

    public static List<Triple> extractTriples(Element e) {
        ArrayList<Triple> result = new ArrayList<Triple>();
        ElementUtils.extractTriples(e, result);
        return result;
    }

    public static Triple extractTriple(Element e) {
        Triple result = null;
        if (e instanceof ElementFilter) {
            ElementFilter x = (ElementFilter)e;
            Expr expr = x.getExpr();
            Set<Set<Expr>> cnf = CnfUtils.toSetCnf(expr);
            Map<Var, Node> map = CnfUtils.getConstants(cnf);
            Node s = (Node)MapUtils.getOrElse(map, (Object)Vars.s, (Object)Node.ANY);
            Node p = (Node)MapUtils.getOrElse(map, (Object)Vars.p, (Object)Node.ANY);
            Node o = (Node)MapUtils.getOrElse(map, (Object)Vars.o, (Object)Node.ANY);
            result = new Triple(s, p, o);
        } else {
            List<Triple> triples = ElementUtils.extractTriples(e);
            if (triples.size() == 1) {
                result = triples.get(0);
            }
        }
        return result;
    }

    public static void extractTriples(Element e, List<Triple> result) {
        if (e instanceof ElementGroup) {
            ElementGroup g = (ElementGroup)e;
            for (Element item : g.getElements()) {
                ElementUtils.extractTriples(item, result);
            }
        } else if (e instanceof ElementTriplesBlock) {
            ElementTriplesBlock b = (ElementTriplesBlock)e;
            List triples = b.getPattern().getList();
            result.addAll(triples);
        }
    }

    public static Map<Node, Var> createMapFixVarNames(Element element) {
        Collection vars = PatternVars.vars((Element)element);
        Map<Node, Var> result = ElementUtils.createMapFixVarNames(vars);
        return result;
    }

    public static Map<Node, Var> createMapFixVarNames(Collection<Var> vars) {
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create("v", vars);
        HashMap<Node, Var> result = new HashMap<Node, Var>();
        for (Var var : vars) {
            if (!var.getName().startsWith("?") && !var.getName().startsWith("/")) continue;
            result.put((Node)var, (Var)gen.next());
        }
        return result;
    }

    public static Element fixVarNames(Element element) {
        Map<Node, Var> nodeMap = ElementUtils.createMapFixVarNames(element);
        NodeTransformRenameMap nodeTransform = new NodeTransformRenameMap(nodeMap);
        Element result = ElementUtils.applyNodeTransform(element, nodeTransform);
        return result;
    }

    public static Element toElement(Collection<Element> elements) {
        Element result;
        if (elements.size() == 1) {
            result = elements.iterator().next();
        } else {
            ElementGroup e = new ElementGroup();
            for (Element element : elements) {
                e.addElement(element);
            }
            result = e;
        }
        return result;
    }

    public static Element union(Collection<Element> elements) {
        Element result;
        if (elements.size() == 1) {
            result = elements.iterator().next();
        } else {
            ElementUnion e = new ElementUnion();
            for (Element element : elements) {
                e.addElement(element);
            }
            result = e;
        }
        return result;
    }

    public static Element groupIfNeeded(Collection<Element> members) {
        ElementGroup result = members.size() == 1 ? members.iterator().next() : ElementUtils.createElementGroup(members);
        return result;
    }

    public static Element groupIfNeeded(Element ... members) {
        Element result = ElementUtils.groupIfNeeded(Arrays.asList(members));
        return result;
    }

    public static ElementGroup createElementGroup(Iterable<Element> members) {
        ElementGroup result = new ElementGroup();
        for (Element member : members) {
            result.addElement(member);
        }
        return result;
    }

    public static ElementGroup createElementGroup(Element ... members) {
        ElementGroup result = new ElementGroup();
        for (Element member : members) {
            result.addElement(member);
        }
        return result;
    }

    public static Element createRenamedElement(Element element, Map<?, ? extends Node> nodeMap) {
        NodeTransformRenameMap nodeTransform = new NodeTransformRenameMap(nodeMap);
        Element result = ElementUtils.applyNodeTransform(element, nodeTransform);
        return result;
    }

    @Deprecated
    public static Element applyNodeTransform(Element element, NodeTransform nodeTransform) {
        ElementTransformSubst2 elementTransform = new ElementTransformSubst2(nodeTransform);
        ExprTransformNodeElement exprTransform = new ExprTransformNodeElement(nodeTransform, (ElementTransform)elementTransform);
        Element result = ElementTransformer.transform((Element)element, (ElementTransform)elementTransform, (ExprTransform)exprTransform);
        return result;
    }

    public static void copyElements(ElementGroup target, Element source) {
        if (source instanceof ElementGroup) {
            ElementGroup es = (ElementGroup)source;
            for (Element e : es.getElements()) {
                target.addElement(e);
            }
        } else {
            target.addElement(source);
        }
    }

    public static void mergeElements(ElementGroup target, ElementTriplesBlock etb, Element source) {
        if (source instanceof ElementTriplesBlock) {
            ElementTriplesBlock e = (ElementTriplesBlock)source;
            for (Triple t : e.getPattern()) {
                etb.addTriple(t);
            }
        } else if (source instanceof ElementGroup) {
            ElementGroup es = (ElementGroup)source;
            for (Element e : es.getElements()) {
                ElementUtils.mergeElements(target, etb, e);
            }
        } else {
            target.addElement(source);
        }
    }

    public static Element mergeElements(Element first, Element second) {
        ElementGroup tmp = new ElementGroup();
        ElementTriplesBlock etb = new ElementTriplesBlock();
        tmp.addElement((Element)etb);
        ElementUtils.mergeElements(tmp, etb, first);
        ElementUtils.mergeElements(tmp, etb, second);
        ArrayList<Element> els = new ArrayList<Element>();
        for (Element e : tmp.getElements()) {
            if (e instanceof ElementTriplesBlock && ((ElementTriplesBlock)e).isEmpty()) continue;
            els.add(e);
        }
        Element result = ElementUtils.groupIfNeeded(els);
        return result;
    }

    public static Element unionElements(Element first, Element second) {
        ElementUnion result = new ElementUnion();
        ElementUtils.addUnionElements(result, first);
        ElementUtils.addUnionElements(result, second);
        return result;
    }

    public static void addUnionElements(ElementUnion out, Element e) {
        if (e instanceof ElementUnion) {
            ElementUnion u = (ElementUnion)e;
            for (Element m : u.getElements()) {
                out.addElement(m);
            }
        } else if (!(e instanceof ElementGroup) || !((ElementGroup)e).isEmpty()) {
            out.addElement(e);
        }
    }

    public static List<Element> toElementList(Element element) {
        List<Element> result = element instanceof ElementGroup ? ((ElementGroup)element).getElements() : Arrays.asList(element);
        result = new ArrayList<Element>(result);
        return result;
    }

    public static Element flatten(Element e) {
        ElementGroup tmp;
        List els;
        Object result = e instanceof ElementGroup ? ((els = (tmp = (ElementGroup)e).getElements()).size() == 1 ? (Element)els.get(0) : tmp) : e;
        return result;
    }
}

