/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.aksw.commons.collections.IterableCollection;
import org.aksw.commons.collections.trees.Tree;
import org.aksw.commons.collections.trees.TreeImpl;
import org.aksw.commons.util.Pair;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.NodeTransformSignaturize;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.FunctionLabel;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;

public class ExprUtils {
    public static int classify(Expr e) {
        int result = e.isConstant() ? 0 : (e.isVariable() ? 1 : (e.isFunction() ? 2 : 3));
        return result;
    }

    public static int compare(Expr a, Expr b) {
        int ca = ExprUtils.classify(a);
        int cb = ExprUtils.classify(b);
        int r = cb - ca;
        if (r == 0) {
            switch (ca) {
                case 0: {
                    r = NodeValue.compare((NodeValue)a.getConstant(), (NodeValue)b.getConstant());
                    break;
                }
                case 1: {
                    r = a.getVarName().compareTo(b.getVarName());
                    break;
                }
                case 2: {
                    r = a.getFunction().getFunctionIRI().compareTo(b.getFunction().getFunctionIRI());
                    break;
                }
                default: {
                    throw new RuntimeException("should not come here");
                }
            }
        }
        return r;
    }

    public static Tree<Expr> createTree(Expr root) {
        TreeImpl result = TreeImpl.create((Object)root, ExprUtils::getSubExprs);
        return result;
    }

    public static boolean isConstantsOnly(Iterable<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static boolean isConstantArgsOnly(ExprFunction fn) {
        if (fn == null) {
            throw new RuntimeException("Null argument should not happen here");
        }
        boolean result = ExprUtils.isConstantsOnly(fn.getArgs());
        return result;
    }

    public static String getFunctionId(ExprFunction fn) {
        String result = null;
        result = fn.getOpName();
        if (result != null) {
            return result;
        }
        result = fn.getFunctionIRI();
        if (result != null) {
            return result;
        }
        FunctionLabel label = fn.getFunctionSymbol();
        result = label == null ? null : label.getSymbol();
        return result;
    }

    public static <T> int countLeafs(T parent, Function<T, Collection<T>> nodeToChildren) {
        Collection<T> children = nodeToChildren.apply(parent);
        int result = children.isEmpty() ? 1 : children.stream().mapToInt(c -> ExprUtils.countLeafs(c, nodeToChildren)).sum();
        return result;
    }

    public static int countLeafs(Expr expr) {
        int result = ExprUtils.countLeafs(expr, ExprUtils::getSubExprs);
        return result;
    }

    public static <T> Stream<T> linearizePrefix(T op, Collection<T> stopMarker, Function<? super T, Iterable<? extends T>> getChildren) {
        Stream<Object> result;
        if (op == null) {
            result = Stream.empty();
        } else {
            Iterable<T> children = getChildren.apply(op);
            Stream<? extends T> x = StreamSupport.stream(children.spliterator(), false);
            result = Stream.concat(Stream.concat(StreamSupport.stream(children.spliterator(), false).flatMap(e -> ExprUtils.linearizePrefix(e, stopMarker, getChildren)), stopMarker.stream()), Stream.of(op));
        }
        return result;
    }

    public static Stream<Expr> linearizePrefix(Expr expr, Collection<Expr> stopMarkers) {
        Stream<Expr> result = ExprUtils.linearizePrefix(expr, stopMarkers, ExprUtils::getSubExprs);
        return result;
    }

    public static void main(String[] args) {
        System.out.println(ExprUtils.linearizePrefix(org.apache.jena.sparql.util.ExprUtils.parse((String)"?a + ?b + ?c"), null).collect(Collectors.toList()));
    }

    public static Expr signaturize(Expr expr) {
        NodeTransformSignaturize nodeTransform = new NodeTransformSignaturize();
        Expr result = NodeTransformLib.transform((NodeTransform)nodeTransform, (Expr)expr);
        return result;
    }

    public static Expr signaturize(Expr expr, Map<?, ? extends Node> nodeMap) {
        NodeTransformRenameMap baseTransform = new NodeTransformRenameMap(nodeMap);
        NodeTransformSignaturize nodeTransform = new NodeTransformSignaturize(baseTransform);
        Expr result = NodeTransformLib.transform((NodeTransform)nodeTransform, (Expr)expr);
        return result;
    }

    public static Expr applyNodeTransform(Expr expr, Map<?, ? extends Node> nodeMap) {
        NodeTransformRenameMap nodeTransform = new NodeTransformRenameMap(nodeMap);
        Expr result = NodeTransformLib.transform((NodeTransform)nodeTransform, (Expr)expr);
        return result;
    }

    public static Expr andifyBalanced(Expr ... exprs) {
        return ExprUtils.andifyBalanced(Arrays.asList(exprs));
    }

    public static Expr orifyBalanced(Expr ... exprs) {
        return ExprUtils.orifyBalanced(Arrays.asList(exprs));
    }

    public static List<String> extractNames(Collection<Var> vars) {
        ArrayList<String> result = new ArrayList<String>();
        for (Var var : vars) {
            result.add(var.getName());
        }
        return result;
    }

    public static Expr andifyBalanced(Iterable<Expr> exprs) {
        Expr result = ExprUtils.opifyBalanced(exprs, (a, b) -> new E_LogicalAnd(a, b));
        return result;
    }

    public static <T> T distribute(List<T> as, List<T> bs, BinaryOperator<T> innerJunctor, BinaryOperator<T> outerJunctor) {
        ArrayList items = new ArrayList(bs.size());
        for (T a : as) {
            for (T b : bs) {
                Object item = innerJunctor.apply(a, b);
                items.add(item);
            }
        }
        Object result = ExprUtils.opifyBalanced(items, outerJunctor);
        return (T)result;
    }

    public static <T> Optional<T> opify(Iterable<T> exprs, BinaryOperator<T> exprFactory) {
        Optional result;
        Iterator<T> it = exprs.iterator();
        if (!it.hasNext()) {
            result = Optional.empty();
        } else {
            Object tmp = it.next();
            while (it.hasNext()) {
                T b = it.next();
                tmp = exprFactory.apply(tmp, b);
            }
            result = Optional.of(tmp);
        }
        return result;
    }

    public static <T> T opifyBalanced(Iterable<T> exprs, BinaryOperator<T> exprFactory) {
        if (!exprs.iterator().hasNext()) {
            return null;
        }
        ArrayList current = new ArrayList(IterableCollection.wrap(exprs));
        while (current.size() > 1) {
            ArrayList next = new ArrayList();
            Object left = null;
            for (Object expr : current) {
                if (left == null) {
                    left = expr;
                    continue;
                }
                Object newExpr = exprFactory.apply(left, expr);
                next.add(newExpr);
                left = null;
            }
            if (left != null) {
                next.add(left);
            }
            current.clear();
            ArrayList tmp = current;
            current = next;
            ArrayList arrayList = tmp;
        }
        return (T)current.get(0);
    }

    public static Expr orifyBalanced(Iterable<Expr> exprs) {
        Expr result = ExprUtils.opifyBalanced(exprs, (a, b) -> new E_LogicalOr(a, b));
        return result;
    }

    public static Map.Entry<Var, NodeValue> extractConstantConstraint(Expr expr) {
        if (expr instanceof E_Equals) {
            E_Equals e = (E_Equals)expr;
            return ExprUtils.extractVarConstant(e.getArg1(), e.getArg2());
        }
        return null;
    }

    public static Map.Entry<Var, NodeValue> extractVarConstant(Expr expr) {
        ExprFunction f;
        Pair<Var, NodeValue> result = null;
        if (expr instanceof ExprFunction && (f = expr.getFunction()).numArgs() == 2) {
            Expr a = f.getArg(1);
            Expr b = f.getArg(2);
            result = ExprUtils.extractVarConstant(a, b);
        }
        return result;
    }

    public static Pair<Var, NodeValue> extractVarConstant(Expr a, Expr b) {
        Pair<Var, NodeValue> result = ExprUtils.extractVarConstantDirected(a, b);
        if (result == null) {
            result = ExprUtils.extractVarConstantDirected(b, a);
        }
        return result;
    }

    public static Pair<Var, NodeValue> extractVarConstantDirected(Expr a, Expr b) {
        if (!a.isVariable() || !b.isConstant()) {
            return null;
        }
        Var var = a.getExprVar().asVar();
        NodeValue nodeValue = b.getConstant();
        return Pair.create((Object)var, (Object)nodeValue);
    }

    public static List<Expr> getSubExprs(Expr expr) {
        List result = expr != null && expr.isFunction() ? expr.getFunction().getArgs() : Collections.emptyList();
        return result;
    }

    @Deprecated
    public static Collection<? extends Expr> getSubExpressions(Expr expr, boolean reflexive) {
        HashSet<Expr> result = new HashSet<Expr>();
        if (reflexive) {
            result.add(expr);
        }
        ExprUtils.getSubExpressions(expr, result);
        return result;
    }

    @Deprecated
    public static void getSubExpressions(Expr expr, Set<Expr> result) {
        if (expr.isFunction()) {
            ExprFunction f = (ExprFunction)expr;
            for (int i = 1; i <= f.numArgs(); ++i) {
                Expr arg = f.getArg(i);
                if (result.contains(arg)) continue;
                result.add(arg);
                ExprUtils.getSubExpressions(arg, result);
            }
        }
    }
}

