/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.IterableCollection;
import org.aksw.commons.collections.Sample;
import org.aksw.commons.util.Pair;
import org.aksw.jena_sparql_api.utils.ClauseUtils;
import org.aksw.jena_sparql_api.utils.DnfUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.jena_sparql_api.utils.ValueSet;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;

public class FilterUtils {
    public static Expr determineFilterExpr(Quad quad, Set<Set<Expr>> dnf) {
        return DnfUtils.dnfToExpr(FilterUtils.determineFilterDnf(quad, dnf), true);
    }

    public static Pair<Var, NodeValue> extractValueConstraint(Expr expr) {
        if (!(expr instanceof ExprFunction2)) {
            return null;
        }
        ExprFunction func = (ExprFunction)expr;
        Expr a = func.getArg(1);
        Expr b = func.getArg(2);
        if (a.isVariable() == b.isVariable()) {
            return null;
        }
        if (b.isVariable()) {
            Expr tmp = b;
            b = a;
            a = tmp;
        }
        if (!b.isConstant()) {
            return null;
        }
        return Pair.create((Object)a.asVar(), (Object)b.getConstant());
    }

    public static ValueSet<NodeValue> toValueSet(Sample<NodeValue> sample) {
        if (sample.getPositives().size() > 1 || !sample.getPositives().isEmpty() && sample.getNegatives().containsAll(sample.getPositives())) {
            return ValueSet.create();
        }
        if (!sample.getPositives().isEmpty()) {
            sample.getNegatives().clear();
        }
        return sample.getPositives().isEmpty() ? ValueSet.create(sample.getNegatives(), false) : ValueSet.create(sample.getPositives(), true);
    }

    public static Map<Var, ValueSet<NodeValue>> extractValueConstraintsDnf(Set<Set<Expr>> dnf) {
        Map<Object, Object> result = null;
        if (dnf == null) {
            return result;
        }
        for (Set<Expr> clause : dnf) {
            Map<Var, ValueSet<NodeValue>> map = FilterUtils.extractValueConstraintsDnfClause(clause);
            if (result == null) {
                result = map;
                continue;
            }
            Iterator itEntry = result.entrySet().iterator();
            while (itEntry.hasNext()) {
                Map.Entry entry = itEntry.next();
                ValueSet a = (ValueSet)entry.getValue();
                ValueSet<NodeValue> b = map.get(entry.getKey());
                a.merge(b);
                if (!a.isUnknown()) continue;
                itEntry.remove();
            }
            if (!result.isEmpty()) continue;
            break;
        }
        return result == null ? new HashMap() : result;
    }

    public static void addValueToSample(Sample<NodeValue> sample, NodeValue nodeValue, boolean isNegative) {
    }

    public static <T> Set<T> intersection(Set<T> a, Set<T> b) {
        return a == null ? (b == null ? null : new HashSet<T>(b)) : new HashSet(Sets.intersection(a, b));
    }

    public static <T> Set<T> union(Set<T> a, Set<T> b) {
        return a == null ? (b == null ? null : new HashSet<T>(b)) : new HashSet(Sets.union(a, b));
    }

    public static Map<Var, ValueSet<NodeValue>> extractValueConstraintsDnfClause(Set<Expr> dnfClause) {
        HashMap<Object, Sample> tmp = new HashMap<Object, Sample>();
        for (Expr expr : dnfClause) {
            Pair<Var, NodeValue> constraint;
            boolean isNegative = expr instanceof E_LogicalNot;
            if (isNegative) {
                expr = ((E_LogicalNot)expr).getArg();
            }
            if (!(expr instanceof E_Equals) || (constraint = FilterUtils.extractValueConstraint(expr)) == null) continue;
            Sample sample = (Sample)tmp.get(constraint.getKey());
            if (sample == null) {
                sample = Sample.create();
                tmp.put(constraint.getKey(), sample);
            }
            if (isNegative) {
                sample.getNegatives().add(constraint.getValue());
                continue;
            }
            sample.getPositives().add(constraint.getValue());
        }
        HashMap<Var, ValueSet<NodeValue>> result = new HashMap<Var, ValueSet<NodeValue>>();
        for (Map.Entry entry : tmp.entrySet()) {
            ValueSet<NodeValue> valueSet = FilterUtils.toValueSet((Sample<NodeValue>)((Sample)entry.getValue()));
            if (valueSet.isUnknown()) continue;
            result.put((Var)entry.getKey(), valueSet);
        }
        return result;
    }

    public static Set<Set<Expr>> determineFilterDnf(Quad quad, Set<Set<Expr>> dnf) {
        if (dnf == null) {
            return null;
        }
        Set<Var> quadVars = QuadUtils.getVarsMentioned(quad);
        for (Set<Expr> clause : dnf) {
            quadVars.retainAll(ClauseUtils.getVarsMentioned(clause));
        }
        HashSet result = null;
        if (quadVars.isEmpty()) {
            return result;
        }
        for (Set<Expr> clause : dnf) {
            HashSet<Expr> c = null;
            for (Expr expr : clause) {
                if (!quadVars.containsAll(expr.getVarsMentioned())) continue;
                if (c == null) {
                    c = new HashSet<Expr>();
                }
                c.add(expr);
            }
            if (c == null) continue;
            if (result == null) {
                result = new HashSet();
            }
            result.add(c);
        }
        return result;
    }

    public boolean isUnsatsfiable(Expr expr, Binding partialBinding) {
        return false;
    }

    public static Set<Set<Expr>> toSets(List<ExprList> clauses) {
        if (clauses == null) {
            return null;
        }
        HashSet<Set<Expr>> result = new HashSet<Set<Expr>>();
        for (ExprList clause : clauses) {
            result.add(new HashSet(IterableCollection.wrap((Iterable)clause)));
        }
        return result;
    }

    public static ExprList collectExprs(Op op, ExprList result) {
        if (op instanceof OpLeftJoin) {
            OpLeftJoin x = (OpLeftJoin)op;
            if (x.getExprs() != null) {
                result.addAll(x.getExprs());
            }
            FilterUtils.collectExprs(x.getLeft(), result);
            FilterUtils.collectExprs(x.getRight(), result);
        } else if (op instanceof OpFilter) {
            OpFilter x = (OpFilter)op;
            result.addAll(x.getExprs());
            FilterUtils.collectExprs(x.getSubOp(), result);
        } else if (op instanceof OpJoin) {
            OpJoin x = (OpJoin)op;
            FilterUtils.collectExprs(x.getLeft(), result);
            FilterUtils.collectExprs(x.getRight(), result);
        } else if (op instanceof OpUnion) {
            System.out.println("Warning: Collecting expressions from unions. Since the same vars may appear within different (parts of) unions, it may be ambiguous to which part the expression refers.");
            OpUnion x = (OpUnion)op;
            FilterUtils.collectExprs(x.getLeft(), result);
            FilterUtils.collectExprs(x.getRight(), result);
        } else if (!(op instanceof OpQuadPattern)) {
            if (op instanceof OpSequence) {
                OpSequence x = (OpSequence)op;
                for (Op element : x.getElements()) {
                    FilterUtils.collectExprs(element, result);
                }
            } else {
                throw new RuntimeException("Not implemented. Type: " + op.getClass());
            }
        }
        return result;
    }

    public static boolean isDnfSubsumed(Set<Set<Expr>> clausesA, Set<Set<Expr>> clausesB) {
        for (Set<Expr> clauseA : clausesA) {
            boolean isClauseSubsumed = false;
            for (Set<Expr> clauseB : clausesB) {
                boolean tmp = FilterUtils.isDnfClauseSubsumed(clauseA, clauseB);
                isClauseSubsumed = isClauseSubsumed || tmp;
            }
            if (isClauseSubsumed) continue;
            return false;
        }
        return true;
    }

    public static boolean isDnfClauseSubsumed(Set<Expr> clauseA, Set<Expr> clauseB) {
        return clauseB.containsAll(clauseA);
    }
}

