/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.Streams;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphUtils {
    public static Stream<Triple> createTripleStream(String resourceName) {
        TypedInputStream in = RDFDataMgr.open((String)resourceName);
        Lang lang = RDFDataMgr.determineLang((String)resourceName, (String)in.getContentType(), (Lang)Lang.TURTLE);
        Iterator it = RDFDataMgr.createIteratorTriples((InputStream)in, (Lang)lang, (String)"http://example.org/");
        return Streams.stream((Iterator)it);
    }

    public static Graph toMemGraph(Iterable<Triple> triples) {
        Graph result = GraphFactory.createGraphMem();
        triples.forEach(arg_0 -> ((Graph)result).add(arg_0));
        return result;
    }

    public static Map<Node, Graph> indexBySubject(Graph graph) {
        Map<Node, Graph> result;
        try (ExtendedIterator it = graph.find(Node.ANY, Node.ANY, Node.ANY);){
            result = GraphUtils.indexBySubject((Iterator<Triple>)it);
        }
        return result;
    }

    public static Map<Node, Graph> indexBySubject(Iterable<Triple> triples) {
        Map<Node, Graph> result = GraphUtils.indexBySubject(triples.iterator());
        return result;
    }

    public static Map<Node, Graph> indexBySubject(Iterator<Triple> it) {
        HashMap<Node, Graph> result = new HashMap<Node, Graph>();
        while (it.hasNext()) {
            Triple triple = it.next();
            Node s = triple.getSubject();
            Graph graph = (Graph)result.get(s);
            if (graph == null) {
                graph = GraphFactory.createGraphMem();
                result.put(s, graph);
            }
            graph.add(triple);
        }
        return result;
    }
}

