/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.utils.functions.F_QuadGetObject;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

public class ListObjectsOfDatasetGraph
extends AbstractList<Node> {
    protected DatasetGraph datasetGraph;
    protected Quad quad;
    protected List<Node> objects;

    public ListObjectsOfDatasetGraph(DatasetGraph datasetGraph, Quad quad, List<Node> objects) {
        this.datasetGraph = datasetGraph;
        this.quad = quad;
        this.objects = objects;
    }

    public Quad createQuad(Node o) {
        Node g = this.quad.getGraph();
        Node s = this.quad.getSubject();
        Node p = this.quad.getPredicate();
        Quad result = new Quad(g, s, p, o);
        return result;
    }

    @Override
    public boolean add(Node o) {
        Quad quad = this.createQuad(o);
        boolean isContained = this.datasetGraph.contains(quad);
        if (!isContained) {
            this.datasetGraph.add(quad);
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        boolean result = this.objects.contains(o);
        return result;
    }

    @Override
    public boolean remove(Object obj) {
        boolean result = false;
        if (obj instanceof Node) {
            Node o = (Node)obj;
            this.objects.remove(o);
            Quad quad = this.createQuad(o);
            result = this.datasetGraph.contains(quad);
            this.datasetGraph.delete(quad);
        }
        return result;
    }

    public static List<Node> getObjects(DatasetGraph datasetGraph, Quad quad) {
        Iterator it = datasetGraph.find(quad);
        ArrayList quads = Lists.newArrayList((Iterator)it);
        List result = Lists.transform((List)quads, (Function)F_QuadGetObject.fn);
        return result;
    }

    @Override
    public Node get(int index) {
        Node result = this.objects.get(index);
        return result;
    }

    @Override
    public Node remove(int index) {
        Node result = this.objects.get(index);
        Quad quad = this.createQuad(result);
        this.datasetGraph.delete(quad);
        return result;
    }

    @Override
    public Node set(int index, Node node) {
        Node old = this.objects.get(index);
        this.objects.set(index, node);
        Quad oq = this.createQuad(old);
        Quad nq = this.createQuad(node);
        this.datasetGraph.delete(oq);
        this.datasetGraph.add(nq);
        return node;
    }

    @Override
    public int size() {
        Iterator it = this.datasetGraph.find(this.quad);
        int result = Iterators.size((Iterator)it);
        return result;
    }

    public static ListObjectsOfDatasetGraph create(DatasetGraph datasetGraph, Quad quad) {
        ArrayList<Node> objects = new ArrayList<Node>(ListObjectsOfDatasetGraph.getObjects(datasetGraph, quad));
        ListObjectsOfDatasetGraph result = new ListObjectsOfDatasetGraph(datasetGraph, quad, objects);
        return result;
    }

    public static ListObjectsOfDatasetGraph create(DatasetGraph datasetGraph, Node g, Node s, Node p) {
        Quad quad = new Quad(g, s, p, Node.ANY);
        ListObjectsOfDatasetGraph result = ListObjectsOfDatasetGraph.create(datasetGraph, quad);
        return result;
    }
}

