/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.collections.multimaps.IBiSetMultimap;

public class MapUtils {
    public static <K, V> Map<K, V> index(Collection<K> keys, Function<K, V> fn) {
        Map<K, V> result = MapUtils.index(keys, fn, new HashMap());
        return result;
    }

    public static <K, V> Map<K, V> indexIdentity(Collection<K> keys, Function<K, V> fn) {
        Map<K, V> result = MapUtils.index(keys, fn, new IdentityHashMap());
        return result;
    }

    public static <K, V> Map<K, V> index(Collection<K> keys, Function<K, V> fn, Map<K, V> result) {
        for (K key : keys) {
            V value = fn.apply(key);
            result.put(key, value);
        }
        return result;
    }

    public static <K, V> Map<K, V> merge(Map<K, V> a, Map<K, V> b) {
        Map<Object, Object> result = Stream.of(a, b).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return result;
    }

    public static <K, V> Map<K, Map.Entry<Set<V>, Set<V>>> groupByKey(IBiSetMultimap<K, V> a, IBiSetMultimap<K, V> b) {
        HashMap result = new HashMap();
        Sets.SetView keys = Sets.union((Set)a.keySet(), (Set)b.keySet());
        keys.forEach(k -> {
            Set av = SetUtils.asSet((Iterable)a.get(k));
            Set bv = SetUtils.asSet((Iterable)b.get(k));
            AbstractMap.SimpleEntry<Set, Set> e = new AbstractMap.SimpleEntry<Set, Set>(av, bv);
            result.put(k, e);
        });
        return result;
    }

    public static <K, V> Map<K, Map.Entry<Set<V>, Set<V>>> groupByKey(Map<K, ? extends Iterable<V>> a, Map<K, ? extends Iterable<V>> b) {
        HashMap result = new HashMap();
        Sets.SetView keys = Sets.union(a.keySet(), b.keySet());
        keys.forEach(k -> {
            Iterable ax = (Iterable)a.get(k);
            Iterable bx = (Iterable)b.get(k);
            Set av = ax == null ? Collections.emptySet() : SetUtils.asSet((Iterable)ax);
            Set bv = bx == null ? Collections.emptySet() : SetUtils.asSet((Iterable)bx);
            AbstractMap.SimpleEntry<Set, Set> e = new AbstractMap.SimpleEntry<Set, Set>(av, bv);
            result.put(k, e);
        });
        return result;
    }

    public static <X, Y> Map<X, Y> mergeIfCompatible(Map<X, Y> base, Map<X, Y> addition) {
        boolean isCompatible;
        HashMap<X, Y> result = null;
        if (base != null && addition != null && (isCompatible = org.aksw.commons.collections.MapUtils.isPartiallyCompatible(base, addition))) {
            result = new HashMap<X, Y>();
            result.putAll(base);
            result.putAll(addition);
        }
        return result;
    }

    public static <X, Y> Map<X, Y> mergeInPlaceIfCompatible(Map<X, Y> inout, Map<X, Y> addition) {
        boolean isCompatible;
        Map<X, Y> result = null;
        if (inout != null && addition != null && (isCompatible = org.aksw.commons.collections.MapUtils.isPartiallyCompatible(inout, addition))) {
            inout.putAll(addition);
            result = inout;
        }
        return result;
    }
}

