/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.StringWriterI;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.sparql.core.Var;

public class NodeUtils {
    public static Node asNullableNode(String uri) {
        Node result = uri == null ? null : NodeFactory.createURI((String)uri);
        return result;
    }

    public static List<Node> fromUris(Iterable<String> uris) {
        ArrayList<Node> result = new ArrayList<Node>(Iterables.size(uris));
        for (String uri : uris) {
            Node node = NodeFactory.createURI((String)uri);
            result.add(node);
        }
        return result;
    }

    public static Node createTypedLiteral(TypeMapper typeMapper, Object o) {
        Class<?> clazz = o.getClass();
        RDFDatatype dtype = typeMapper.getTypeByClass(clazz);
        String lex = dtype.unparse(o);
        Node result = NodeFactory.createLiteral((String)lex, (RDFDatatype)dtype);
        return result;
    }

    public static Set<Node> getBnodesMentioned(Iterable<Node> nodes) {
        HashSet<Node> result = new HashSet<Node>();
        for (Node node : nodes) {
            if (!node.isBlank()) continue;
            result.add(node);
        }
        return result;
    }

    public static Set<Var> getVarsMentioned(Iterable<Node> nodes) {
        HashSet<Var> result = new HashSet<Var>();
        for (Node node : nodes) {
            if (!node.isVariable()) continue;
            result.add((Var)node);
        }
        return result;
    }

    public static String toNTriplesString(Node node) {
        NodeFormatterNT formatter = new NodeFormatterNT();
        StringWriterI writer = new StringWriterI();
        formatter.format((AWriter)writer, node);
        String result = writer.toString();
        return result;
    }

    @Deprecated
    public static String toNTriplesStringOld(Node node) {
        String result;
        if (node.isURI()) {
            result = "<" + node.getURI() + ">";
        } else if (node.isLiteral()) {
            String lex = node.getLiteralLexicalForm();
            String lang = node.getLiteralLanguage();
            String dt = node.getLiteralDatatypeURI();
            String tmp = lex;
            tmp = tmp.replace("\\", "\\\\");
            tmp = tmp.replace("\"", "\\\"");
            tmp = tmp.replace("\n", "\\n");
            tmp = tmp.replace("\t", "\\t");
            String encoded = tmp = tmp.replace("\r", "\\r");
            String quote = "\"";
            result = quote + encoded + quote;
            if (dt != null && !dt.isEmpty()) {
                result = result + "^^<" + dt + ">";
            } else if (!lang.isEmpty()) {
                result = result + "@" + lang;
            }
        } else if (node.isBlank()) {
            result = "_:" + node.getBlankNodeLabel();
        } else if (node.isVariable()) {
            result = "?" + ((Var)node).getVarName();
        } else {
            throw new RuntimeException("Cannot serialize [" + node + "] as N-Triples");
        }
        return result;
    }
}

