/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.NodeTransformSignaturize;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.jena_sparql_api.utils.TripleUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.util.NodeComparator;
import org.apache.jena.sparql.util.TripleComparator;

public class QuadPatternUtils {
    public static QuadPattern signaturize(QuadPattern quadPattern) {
        NodeTransformSignaturize nodeTransform = new NodeTransformSignaturize();
        QuadPattern result = NodeTransformLib.transform((NodeTransform)nodeTransform, (QuadPattern)quadPattern);
        return result;
    }

    public static QuadPattern signaturize(QuadPattern quadPattern, Map<?, ? extends Node> nodeMap) {
        NodeTransformRenameMap baseTransform = new NodeTransformRenameMap(nodeMap);
        NodeTransformSignaturize nodeTransform = new NodeTransformSignaturize(baseTransform);
        QuadPattern result = NodeTransformLib.transform((NodeTransform)nodeTransform, (QuadPattern)quadPattern);
        return result;
    }

    public static String toNTripleString(QuadPattern quadPattern) throws Exception {
        List quads = quadPattern.getList();
        String result = "";
        for (Quad quad : quads) {
            Triple triple = quad.asTriple();
            String tmp = TripleUtils.toNTripleString(triple);
            if (!result.isEmpty()) {
                result = result + "\n";
            }
            result = result + tmp;
        }
        return result;
    }

    public static QuadPattern create(Iterable<Quad> quads) {
        QuadPattern result = new QuadPattern();
        for (Quad quad : quads) {
            result.add(quad);
        }
        return result;
    }

    public static QuadPattern toQuadPattern(BasicPattern basicPattern) {
        return QuadPatternUtils.toQuadPattern(Quad.defaultGraphNodeGenerated, basicPattern);
    }

    public static QuadPattern toQuadPattern(Node g, BasicPattern basicPattern) {
        QuadPattern result = new QuadPattern();
        for (Triple triple : basicPattern) {
            Quad quad = new Quad(g, triple);
            result.add(quad);
        }
        return result;
    }

    public static BasicPattern toBasicPattern(QuadPattern quadPattern) {
        BasicPattern result = new BasicPattern();
        for (Quad quad : quadPattern) {
            Triple triple = quad.asTriple();
            result.add(triple);
        }
        return result;
    }

    public static Map<Node, BasicPattern> indexBasicPattern(Iterable<Quad> quads) {
        HashMap<Node, BasicPattern> result = new HashMap<Node, BasicPattern>();
        for (Quad q : quads) {
            BasicPattern basicPattern = (BasicPattern)result.get(q.getGraph());
            if (basicPattern == null) {
                basicPattern = new BasicPattern();
                result.put(q.getGraph(), basicPattern);
            }
            basicPattern.add(q.asTriple());
        }
        return result;
    }

    public static Map<Node, Set<Triple>> indexSorted(Iterable<Quad> quads) {
        TreeMap<Node, Set<Triple>> result = new TreeMap<Node, Set<Triple>>((Comparator<Node>)new NodeComparator());
        for (Quad q : quads) {
            TreeSet<Triple> triples = (TreeSet<Triple>)result.get(q.getGraph());
            if (triples == null) {
                triples = new TreeSet<Triple>((Comparator<Triple>)new TripleComparator());
                result.put(q.getGraph(), triples);
            }
            triples.add(q.asTriple());
        }
        return result;
    }

    public static Map<Node, Graph> indexAsGraphs(Iterable<Quad> quads) {
        Map<Node, Graph> result = QuadPatternUtils.indexAsGraphs(quads.iterator());
        return result;
    }

    public static Map<Node, Graph> indexAsGraphs(Iterator<Quad> it) {
        HashMap<Node, Graph> result = new HashMap<Node, Graph>();
        while (it.hasNext()) {
            Quad quad = it.next();
            Graph graph = (Graph)result.get(quad.getGraph());
            if (graph == null) {
                graph = GraphFactory.createDefaultGraph();
                result.put(quad.getGraph(), graph);
            }
            graph.add(quad.asTriple());
        }
        return result;
    }

    public static Set<Var> getVarsMentioned(Iterable<? extends Quad> quadPattern) {
        HashSet<Var> result = new HashSet<Var>();
        for (Quad quad : quadPattern) {
            Set<Var> tmp = QuadUtils.getVarsMentioned(quad);
            result.addAll(tmp);
        }
        return result;
    }
}

