/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.collections.MapUtils;
import org.aksw.jena_sparql_api.utils.NodeUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;

public class QuadUtils {
    public static final String ng = "g";
    public static final String ns = "s";
    public static final String np = "p";
    public static final String no = "o";
    public static final List<String> quadVarNames = Arrays.asList("g", "s", "p", "o");
    public static final Var vg = Var.alloc((String)"g");
    public static final Var vs = Var.alloc((String)"s");
    public static final Var vp = Var.alloc((String)"p");
    public static final Var vo = Var.alloc((String)"o");
    public static final List<Var> quadVars = Arrays.asList(vg, vs, vp, vo);

    public static Map<Node, Set<Quad>> partitionByGraph(Iterable<Quad> quads) {
        HashMap<Node, Set<Quad>> result = new HashMap<Node, Set<Quad>>();
        for (Quad quad : quads) {
            Node g = quad.getGraph();
            HashSet<Quad> qs = (HashSet<Quad>)result.get(g);
            if (qs == null) {
                qs = new HashSet<Quad>();
                result.put(g, qs);
            }
            qs.add(quad);
        }
        return result;
    }

    public static Map<Node, Set<Triple>> partitionByGraphTriples(Iterable<Quad> quads) {
        HashMap<Node, Set<Triple>> result = new HashMap<Node, Set<Triple>>();
        for (Quad quad : quads) {
            Node g = quad.getGraph();
            HashSet<Triple> ts = (HashSet<Triple>)result.get(g);
            if (ts == null) {
                ts = new HashSet<Triple>();
                result.put(g, ts);
            }
            Triple t = quad.asTriple();
            ts.add(t);
        }
        return result;
    }

    public static Element toElement(Iterable<Quad> quads) {
        Map<Node, Set<Quad>> map = QuadUtils.partitionByGraph(quads);
        Element result = QuadUtils.toElement(map);
        return result;
    }

    public static Element toElement(Map<Node, Set<Quad>> graphToQuads) {
        ElementGroup es = new ElementGroup();
        for (Map.Entry<Node, Set<Quad>> entry : graphToQuads.entrySet()) {
            ElementTriplesBlock e = new ElementTriplesBlock();
            for (Quad quad : entry.getValue()) {
                Triple triple = quad.asTriple();
                e.addTriple(triple);
            }
            Node graph = entry.getKey();
            ElementTriplesBlock f = graph == null || graph.equals((Object)Quad.defaultGraphNodeGenerated) ? e : new ElementNamedGraph(graph, (Element)e);
            es.addElement((Element)f);
        }
        ElementGroup result = es.getElements().size() == 1 ? (Element)es.getElements().get(0) : es;
        return result;
    }

    public static Binding quadToBinding(Quad quad) {
        BindingHashMap result = new BindingHashMap();
        result.add(vg, quad.getGraph());
        result.add(vs, quad.getSubject());
        result.add(vp, quad.getPredicate());
        result.add(vo, quad.getObject());
        return result;
    }

    public static <K, V> Map<K, V> copySubstitute(Map<K, V> original, Map<K, K> map) {
        HashMap<Object, V> result = new HashMap<Object, V>();
        for (Map.Entry<K, V> entry : original.entrySet()) {
            result.put(MapUtils.getOrElse(map, entry.getKey(), entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static Set<Quad> applyNodeTransform(Set<Quad> quads, NodeTransform nodeTransform) {
        HashSet<Quad> result = new HashSet<Quad>();
        for (Quad quad : quads) {
            Quad newQuad = QuadUtils.applyNodeTransform(quad, nodeTransform);
            result.add(newQuad);
        }
        return result;
    }

    public static Quad applyNodeTransform(Quad quad, NodeTransform nodeTransform) {
        Node g = (Node)nodeTransform.apply((Object)quad.getGraph());
        Node s = (Node)nodeTransform.apply((Object)quad.getSubject());
        Node p = (Node)nodeTransform.apply((Object)quad.getPredicate());
        Node o = (Node)nodeTransform.apply((Object)quad.getObject());
        g = g != null ? g : quad.getGraph();
        s = s != null ? s : quad.getSubject();
        p = p != null ? p : quad.getPredicate();
        o = o != null ? o : quad.getObject();
        Quad result = new Quad(g, s, p, o);
        return result;
    }

    public static Quad copySubstitute(Quad quad, Map<? extends Node, ? extends Node> map) {
        return new Quad((Node)MapUtils.getOrElse(map, (Object)quad.getGraph(), (Object)quad.getGraph()), (Node)MapUtils.getOrElse(map, (Object)quad.getSubject(), (Object)quad.getSubject()), (Node)MapUtils.getOrElse(map, (Object)quad.getPredicate(), (Object)quad.getPredicate()), (Node)MapUtils.getOrElse(map, (Object)quad.getObject(), (Object)quad.getObject()));
    }

    public static Quad create(Node[] nodes) {
        return new Quad(nodes[0], nodes[1], nodes[2], nodes[3]);
    }

    public static Node getNode(Quad quad, int index) {
        switch (index) {
            case 0: {
                return quad.getGraph();
            }
            case 1: {
                return quad.getSubject();
            }
            case 2: {
                return quad.getPredicate();
            }
            case 3: {
                return quad.getObject();
            }
        }
        throw new IndexOutOfBoundsException("Index: " + index + " Size: " + 4);
    }

    public static Node substitute(Node node, Binding binding) {
        Node result = node;
        if (node.isVariable() && (result = binding.get((Var)node)) == null) {
            throw new RuntimeException("Variable " + node + "not bound");
        }
        return result;
    }

    public static Quad copySubstitute(Quad quad, Binding binding) {
        return new Quad(QuadUtils.substitute(quad.getGraph(), binding), QuadUtils.substitute(quad.getSubject(), binding), QuadUtils.substitute(quad.getPredicate(), binding), QuadUtils.substitute(quad.getObject(), binding));
    }

    public static QuadPattern copySubstitute(QuadPattern quadPattern, Map<? extends Node, ? extends Node> map) {
        QuadPattern result = new QuadPattern();
        for (Quad quad : quadPattern) {
            result.add(QuadUtils.copySubstitute(quad, map));
        }
        return result;
    }

    public static Quad listToQuad(List<Node> nodes) {
        return new Quad(nodes.get(0), nodes.get(1), nodes.get(2), nodes.get(3));
    }

    public static Quad arrayToQuad(Node[] nodes) {
        return new Quad(nodes[0], nodes[1], nodes[2], nodes[3]);
    }

    public static Node[] quadToArray(Quad quad) {
        return new Node[]{quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject()};
    }

    public static List<Node> quadToList(Quad quad) {
        ArrayList<Node> result = new ArrayList<Node>();
        result.add(quad.getGraph());
        result.add(quad.getSubject());
        result.add(quad.getPredicate());
        result.add(quad.getObject());
        return result;
    }

    public static Set<Var> getVarsMentioned(Quad quad) {
        return NodeUtils.getVarsMentioned(QuadUtils.quadToList(quad));
    }

    public static Map<Node, Node> getVarMapping(Quad a, Quad b) {
        List<Node> nAs = QuadUtils.quadToList(a);
        List<Node> nBs = QuadUtils.quadToList(b);
        HashMap<Node, Node> result = new HashMap<Node, Node>();
        for (int i = 0; i < 4; ++i) {
            Node nA = nAs.get(i);
            Node nB = nBs.get(i);
            if (nA.isVariable()) {
                Map<Node, Node> newEntry = Collections.singletonMap(nA, nB);
                result.putAll(newEntry);
                continue;
            }
            if (nA.equals((Object)nB)) continue;
            return null;
        }
        return result;
    }
}

