/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.backports.syntaxtransform.ElementTransformSubst;
import org.aksw.jena_sparql_api.backports.syntaxtransform.ExprTransformNodeElement;
import org.aksw.jena_sparql_api.backports.syntaxtransform.QueryTransformOps;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.aksw.jena_sparql_api.utils.transform.NodeTransformCollectNodes;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.util.ExprUtils;

public class QueryUtils {
    public static Query applyNodeTransform(Query query, NodeTransform nodeTransform) {
        ElementTransformSubst eltrans = new ElementTransformSubst(nodeTransform);
        ExprTransformNodeElement exprTrans = new ExprTransformNodeElement(nodeTransform, eltrans);
        Query result = QueryTransformOps.transform(query, eltrans, (ExprTransform)exprTrans);
        return result;
    }

    public static PrefixMapping usedPrefixes(Query query) {
        NodeTransformCollectNodes nodeUsageCollector = new NodeTransformCollectNodes();
        QueryUtils.applyNodeTransform(query, nodeUsageCollector);
        Set<Node> nodes = nodeUsageCollector.getNodes();
        PrefixMapping pm = query.getPrefixMapping();
        Map<String, String> usedPrefixes = nodes.stream().filter(Node::isURI).map(Node::getURI).map(x -> {
            String tmp = pm.shortForm(x);
            String r = Objects.equals(x, tmp) ? null : tmp.split(":", 2)[0];
            return r;
        }).filter(x -> x != null).distinct().collect(Collectors.toMap(x -> x, arg_0 -> ((PrefixMapping)pm).getNsPrefixURI(arg_0)));
        PrefixMappingImpl result = new PrefixMappingImpl();
        result.setNsPrefixes(usedPrefixes);
        return result;
    }

    public static Query randomizeVars(Query query) {
        Map<Var, Var> varMap = QueryUtils.createRandomVarMap(query, "rv");
        Query result = QueryTransformOps.transform(query, varMap);
        return result;
    }

    public static Map<Var, Var> createRandomVarMap(Query query, String base) {
        Collection vars = PatternVars.vars((Element)query.getQueryPattern());
        VarGeneratorBlacklist gen = VarGeneratorBlacklist.create(base, (Collection<Var>)vars);
        Map<Var, Var> varMap = vars.stream().collect(Collectors.toMap(v -> v, v -> (Var)gen.next()));
        return varMap;
    }

    public static void injectFilter(Query query, String exprStr) {
        Expr expr = ExprUtils.parse((String)exprStr);
        QueryUtils.injectFilter(query, expr);
    }

    public static void injectFilter(Query query, Expr expr) {
        QueryUtils.injectElement(query, (Element)new ElementFilter(expr));
    }

    public static void injectElement(Query query, Element element) {
        Element queryPattern = query.getQueryPattern();
        Element replacement = ElementUtils.mergeElements(queryPattern, element);
        query.setQueryPattern(replacement);
    }

    public static Range<Long> toRange(OpSlice op) {
        Range<Long> result = QueryUtils.toRange(op.getStart(), op.getLength());
        return result;
    }

    public static Op applyRange(Op op, Range<Long> range) {
        long start = QueryUtils.rangeToOffset(range);
        long length = QueryUtils.rangeToLimit(range);
        OpSlice result = start == Long.MIN_VALUE && length == Long.MIN_VALUE ? op : new OpSlice(op, start, length);
        return result;
    }

    public static Query applySlice(Query query, Long offset, Long limit, boolean cloneOnChange) {
        Query result;
        Range<Long> parent = QueryUtils.toRange(query);
        Range<Long> child = QueryUtils.toRange(offset, limit);
        Range<Long> subRange = QueryUtils.subRange(parent, child);
        boolean isUnchanged = ((Long)parent.lowerEndpoint()).equals(subRange.lowerEndpoint()) && parent.hasUpperBound() == subRange.hasUpperBound() && (!parent.hasUpperBound() || ((Long)parent.upperEndpoint()).equals(subRange.upperEndpoint()));
        boolean hasChanged = !isUnchanged;
        Query query2 = result = cloneOnChange && hasChanged ? query.cloneQuery() : query;
        if (hasChanged) {
            QueryUtils.applyRange(result, subRange);
        }
        return result;
    }

    public static void applyRange(Query query, Range<Long> range) {
        long offset = QueryUtils.rangeToOffset(range);
        long limit = QueryUtils.rangeToLimit(range);
        query.setOffset(offset);
        query.setLimit(limit);
    }

    public static Range<Long> createRange(Long limit, Long offset) {
        long beginIndex = offset == null ? 0L : offset;
        Long endIndex = limit == null ? null : Long.valueOf(beginIndex + limit);
        Range result = endIndex == null ? Range.atLeast((Comparable)Long.valueOf(beginIndex)) : Range.closedOpen((Comparable)Long.valueOf(beginIndex), (Comparable)endIndex);
        return result;
    }

    public static long rangeToOffset(Range<Long> range) {
        long result = range == null ? 0L : (Long)range.lowerEndpoint();
        result = result == 0L ? Long.MIN_VALUE : result;
        return result;
    }

    public static long rangeToLimit(Range<Long> range) {
        range = range == null ? null : range.canonical(DiscreteDomain.longs());
        long result = range == null || !range.hasUpperBound() ? Long.MIN_VALUE : DiscreteDomain.longs().distance(range.lowerEndpoint(), range.upperEndpoint());
        return result;
    }

    public static Range<Long> toRange(Query query) {
        Range<Long> result = QueryUtils.toRange(query.getOffset(), query.getLimit());
        return result;
    }

    public static Range<Long> toRange(Long offset, Long limit) {
        Long min = offset == null || offset.equals(Long.MIN_VALUE) ? 0L : offset;
        Long delta = limit == null || limit.equals(Long.MIN_VALUE) ? null : limit;
        Long max = delta == null ? null : Long.valueOf(min + delta);
        Range result = max == null ? Range.atLeast((Comparable)min) : Range.closedOpen((Comparable)min, (Comparable)max);
        return result;
    }

    public static Range<Long> subRange(Range<Long> parent, Range<Long> child) {
        long newMin = (Long)parent.lowerEndpoint() + (Long)child.lowerEndpoint();
        Long newMax = parent.hasUpperBound() ? (child.hasUpperBound() ? Long.valueOf(Math.min((Long)parent.upperEndpoint(), (Long)child.upperEndpoint())) : (Long)parent.upperEndpoint()) : (child.hasUpperBound() ? (Long)child.upperEndpoint() : null);
        Range result = newMax == null ? Range.atLeast((Comparable)Long.valueOf(newMin)) : Range.closed((Comparable)Long.valueOf(newMin), (Comparable)newMax);
        return result;
    }

    public static void applyDatasetDescription(Query query, DatasetDescription dd) {
        DatasetDescription present = query.getDatasetDescription();
        if (present == null && dd != null) {
            List items = dd.getDefaultGraphURIs();
            if (items != null) {
                for (String item : items) {
                    query.addGraphURI(item);
                }
            }
            if ((items = dd.getNamedGraphURIs()) != null) {
                for (String item : items) {
                    query.addNamedGraphURI(item);
                }
            }
        }
    }

    public static Query fixVarNames(Query query) {
        Query result = query.cloneQuery();
        Element element = query.getQueryPattern();
        Element repl = ElementUtils.fixVarNames(element);
        result.setQueryPattern(repl);
        return result;
    }

    public static Query elementToQuery(Element pattern, String resultVar) {
        if (pattern == null) {
            return null;
        }
        Query query = new Query();
        query.setQueryPattern(pattern);
        query.setQuerySelectType();
        if (resultVar == null) {
            query.setQueryResultStar(true);
        }
        query.setResultVars();
        if (resultVar != null) {
            query.getResultVars().add(resultVar);
        }
        return query;
    }

    public static Query elementToQuery(Element pattern) {
        return QueryUtils.elementToQuery(pattern, null);
    }

    public static Set<Quad> instanciate(Iterable<Quad> quads, Binding binding) {
        HashSet<Quad> result = new HashSet<Quad>();
        Node[] nodes = new Node[4];
        for (Quad quad : quads) {
            for (int i = 0; i < 4; ++i) {
                Node node = QuadUtils.getNode(quad, i);
                if (node.isVariable()) {
                    node = binding.get((Var)node);
                }
                if (node == null || i < 3 && node.isLiteral()) {
                    result.clear();
                    return result;
                }
                nodes[i] = node;
            }
            Quad inst = QuadUtils.create(nodes);
            result.add(inst);
        }
        return result;
    }
}

