/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.utils.PageInfo;

public class RangeUtils {
    public static final Range<Long> rangeStartingWithZero = Range.atLeast((Comparable)Long.valueOf(0L));

    public static <C extends Comparable<C>> Range<C> makeAbsolute(Range<C> outer, Range<C> relative, DiscreteDomain<C> domain, BiFunction<C, Long, C> addition) {
        long distance = domain.distance(outer.lowerEndpoint(), relative.lowerEndpoint());
        Range<C> shifted = RangeUtils.shift(relative, distance, domain, addition);
        Range result = shifted.intersection(outer);
        return result;
    }

    public static <C extends Comparable<C>> Range<C> shift(Range<C> range, long distance, DiscreteDomain<C> domain) {
        BiFunction<Comparable, Long, Comparable> addition = (item, d) -> {
            Comparable result = item;
            if (d >= 0L) {
                int i = 0;
                while ((long)i < d) {
                    result = domain.next(item);
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < -d.longValue()) {
                    result = domain.previous(item);
                    ++i;
                }
            }
            return result;
        };
        Range<Comparable> result = RangeUtils.shift(range, distance, domain, addition);
        return result;
    }

    public static <C extends Comparable<C>> Range<C> shift(Range<C> rawRange, long distance, DiscreteDomain<C> domain, BiFunction<C, Long, C> addition) {
        Range result;
        Range range = rawRange.canonical(domain);
        if (range.hasLowerBound()) {
            Comparable oldLower = range.lowerEndpoint();
            Comparable newLower = (Comparable)addition.apply(oldLower, distance);
            if (range.hasUpperBound()) {
                Comparable oldUpper = range.upperEndpoint();
                Comparable newUpper = (Comparable)addition.apply(oldUpper, distance);
                result = Range.closedOpen((Comparable)newLower, (Comparable)newUpper);
            } else {
                result = Range.atLeast((Comparable)oldLower);
            }
        } else {
            throw new IllegalArgumentException("Cannot displace a range without lower bound");
        }
        return result;
    }

    public static <K extends Comparable<K>, V> Set<Map.Entry<Range<K>, V>> getIntersectingRanges(Range<K> r, Collection<Map.Entry<Range<K>, V>> ranges) {
        Set<Map.Entry<Range<K>, V>> result = ranges.stream().filter(e -> !r.intersection((Range)e.getKey()).isEmpty()).collect(Collectors.toSet());
        return result;
    }

    public static Range<Long> startFromZero(Range<Long> range) {
        Range result = range.intersection(rangeStartingWithZero);
        return result;
    }

    public static Range<Long> multiplyByPageSize(Range<Long> range, long pageSize) {
        Range result = range.hasLowerBound() ? (range.hasUpperBound() ? Range.closedOpen((Comparable)Long.valueOf((Long)range.lowerEndpoint() * pageSize), (Comparable)Long.valueOf((Long)range.upperEndpoint() * pageSize)) : Range.atLeast((Comparable)Long.valueOf((Long)range.lowerEndpoint() * pageSize))) : (range.hasUpperBound() ? Range.lessThan((Comparable)Long.valueOf((Long)range.upperEndpoint() * pageSize)) : Range.all());
        return result;
    }

    public static PageInfo<Long> computeRange(Range<Long> range, long pageSize) {
        Range innerRange;
        Range outerRange;
        long o = range.hasLowerBound() ? (Long)range.lowerEndpoint() : 0L;
        long subOffset = o % pageSize;
        o -= subOffset;
        if (range.hasUpperBound()) {
            long limit = (Long)range.upperEndpoint() - (Long)range.lowerEndpoint();
            long l = limit;
            long mod = l % pageSize;
            long extra = mod != 0L ? pageSize - mod : 0L;
            outerRange = Range.closedOpen((Comparable)Long.valueOf(o), (Comparable)Long.valueOf(o + (l += extra)));
            innerRange = Range.closedOpen((Comparable)Long.valueOf(subOffset), (Comparable)Long.valueOf(limit));
        } else {
            outerRange = Range.atLeast((Comparable)Long.valueOf(o));
            innerRange = Range.atLeast((Comparable)Long.valueOf(subOffset));
        }
        PageInfo<Long> result = new PageInfo<Long>(outerRange, innerRange);
        return result;
    }
}

