/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aksw.jena_sparql_api.utils.VarUtils;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;

public class ResultSetPart {
    private List<String> varNames;
    private List<Binding> rows;

    public ResultSetPart() {
        this(Collections.emptyList(), new ArrayList<Binding>());
    }

    public ResultSetPart(List<String> varNames) {
        this(varNames, new ArrayList<Binding>());
    }

    public ResultSetPart(List<String> varNames, List<Binding> rows) {
        this.varNames = varNames;
        this.rows = rows;
    }

    public List<Binding> getBindings() {
        return this.rows;
    }

    public List<String> getVarNames() {
        return this.varNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rows == null ? 0 : this.rows.hashCode());
        result = 31 * result + (this.varNames == null ? 0 : this.varNames.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResultSetPart other = (ResultSetPart)obj;
        if (this.rows == null ? other.rows != null : !this.rows.equals(other.rows)) {
            return false;
        }
        return !(this.varNames == null ? other.varNames != null : !this.varNames.equals(other.varNames));
    }

    public String toString() {
        return "ResultSetPart [varNames=" + this.varNames + ", rows=" + this.rows + "]";
    }

    public static ResultSet toResultSet(ResultSetPart rsp) {
        Iterator<Binding> it = rsp.getBindings().iterator();
        QueryIterPlainWrapper queryIter = new QueryIterPlainWrapper(it);
        ResultSet result = ResultSetFactory.create((QueryIterator)queryIter, rsp.getVarNames());
        return result;
    }

    public static Table toTable(ResultSetPart rsp) {
        List<Var> vars = VarUtils.toList(rsp.getVarNames());
        Table result = TableFactory.create(vars);
        for (Binding binding : rsp.getBindings()) {
            result.addBinding(binding);
        }
        return result;
    }
}

