/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aksw.jena_sparql_api.utils.CloseableQueryExecution;
import org.aksw.jena_sparql_api.utils.IteratorClosable;
import org.aksw.jena_sparql_api.utils.IteratorJoin;
import org.aksw.jena_sparql_api.utils.IteratorResultSetBinding;
import org.aksw.jena_sparql_api.utils.ResultSetPart;
import org.aksw.jena_sparql_api.utils.VarUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class ResultSetUtils {
    public static List<Var> getVars(ResultSet rs) {
        List<Var> result = VarUtils.toList(rs.getResultVars());
        return result;
    }

    public static Integer resultSetToInt(ResultSet rs, Var v) {
        Integer result = null;
        if (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node node = binding.get(v);
            NodeValue nv = NodeValue.makeNode((Node)node);
            result = nv.getInteger().intValue();
        }
        return result;
    }

    public static List<Node> resultSetToList(ResultSet rs, Var v) {
        ArrayList<Node> result = new ArrayList<Node>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node node = binding.get(v);
            result.add(node);
        }
        return result;
    }

    public static Map<Node, ResultSetPart> partition(ResultSet rs, Var var) {
        List varNames = rs.getResultVars();
        LinkedHashMap<Node, ResultSetPart> result = new LinkedHashMap<Node, ResultSetPart>();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node node = binding.get(var);
            ResultSetPart rsp = (ResultSetPart)result.get(node);
            if (rsp == null) {
                rsp = new ResultSetPart(varNames);
                result.put(node, rsp);
            }
            rsp.getBindings().add(binding);
        }
        return result;
    }

    public static ExtendedIterator<Binding> toIteratorBinding(QueryExecution qe) {
        ResultSet rs = qe.execSelect();
        ExtendedIterator<Binding> result = ResultSetUtils.toIteratorBinding(rs, qe);
        return result;
    }

    public static ExtendedIterator<Binding> toIteratorBinding(ResultSet rs, QueryExecution qe) {
        IteratorResultSetBinding it = new IteratorResultSetBinding(rs);
        CloseableQueryExecution closeable = new CloseableQueryExecution(qe);
        IteratorClosable<Binding> tmp = new IteratorClosable<Binding>(it, closeable);
        ExtendedIterator result = WrappedIterator.create(tmp);
        return result;
    }

    public static Iterator<Binding> toIteratorBinding(ResultSet rs) {
        IteratorResultSetBinding result = new IteratorResultSetBinding(rs);
        return result;
    }

    public static Multimap<List<Node>, Binding> index(ResultSet rs, List<Var> vars) {
        LinkedListMultimap result = LinkedListMultimap.create();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            ArrayList<Node> key = new ArrayList<Node>(vars.size());
            for (Var var : vars) {
                Node node = binding.get(var);
                key.add(node);
            }
            result.put(key, (Object)binding);
        }
        return result;
    }

    public static ResultSet join(ResultSet a, ResultSet b) {
        List aVarNames = a.getResultVars();
        HashSet<String> joinVarNames = new HashSet<String>(aVarNames);
        joinVarNames.retainAll(b.getResultVars());
        ArrayList bVarsOnly = new ArrayList(b.getResultVars());
        bVarsOnly.removeAll(joinVarNames);
        ArrayList allVars = new ArrayList(aVarNames);
        allVars.addAll(bVarsOnly);
        List<Var> joinVars = VarUtils.toList(joinVarNames);
        Multimap<List<Node>, Binding> ma = ResultSetUtils.index(a, joinVars);
        Multimap<List<Node>, Binding> mb = ResultSetUtils.index(b, joinVars);
        HashSet keys = new HashSet(ma.keySet());
        keys.retainAll(mb.keySet());
        ma.keySet().retainAll(keys);
        mb.keySet().retainAll(keys);
        IteratorJoin<List<Node>> joinIterator = new IteratorJoin<List<Node>>(keys.iterator(), ma, mb);
        QueryIterPlainWrapper queryIter = new QueryIterPlainWrapper(joinIterator);
        ResultSet result = ResultSetFactory.create((QueryIterator)queryIter, allVars);
        return result;
    }

    public static ResultSet project(ResultSet rs, Iterable<Var> vars, boolean uniq) {
        AbstractCollection newBindings;
        AbstractCollection abstractCollection = newBindings = uniq ? new HashSet() : new ArrayList();
        while (rs.hasNext()) {
            Binding o = rs.nextBinding();
            BindingHashMap n = new BindingHashMap();
            for (Var var : vars) {
                Node node = o.get(var);
                n.add(var, node);
            }
            newBindings.add(n);
        }
        ResultSet result = ResultSetUtils.create2(vars, newBindings.iterator());
        return result;
    }

    public static ResultSet create(List<String> varNames, Iterator<Binding> bindingIt) {
        QueryIterPlainWrapper queryIter = new QueryIterPlainWrapper(bindingIt);
        ResultSet result = ResultSetFactory.create((QueryIterator)queryIter, varNames);
        return result;
    }

    public static ResultSet create2(Iterable<Var> vars, Iterator<Binding> bindingIt) {
        List<String> varNames = VarUtils.getVarNames(vars);
        ResultSet result = ResultSetUtils.create(varNames, bindingIt);
        return result;
    }
}

