/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.rdf.model.impl.Util;

public class UriUtils {
    public static final Pattern replaceNamespacePattern = Pattern.compile("(?<=/)[^/]+(?=/[^/]+/*$)");

    public static String getNameSpace(String s) {
        return s.substring(0, Util.splitNamespaceXML((String)s));
    }

    public static String getLocalName(String s) {
        return s.substring(Util.splitNamespaceXML((String)s));
    }

    public static String replaceNamespace(String base, String replacement) {
        Matcher m = replaceNamespacePattern.matcher(base);
        String result = m.replaceAll(replacement);
        return result;
    }

    public static Multimap<String, String> parseQueryString(String queryString) {
        try {
            return UriUtils.parseQueryStringEx(queryString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Multimap<String, String> parseQueryStringEx(String queryString) throws UnsupportedEncodingException {
        ArrayListMultimap result = ArrayListMultimap.create();
        if (queryString == null) {
            return result;
        }
        for (String param : queryString.split("&")) {
            String[] pair = param.split("=");
            String key = URLDecoder.decode(pair[0], "UTF-8");
            String value = "";
            if (pair.length > 1) {
                value = URLDecoder.decode(pair[1], "UTF-8");
            }
            result.put((Object)new String(key), (Object)new String(value));
        }
        return result;
    }
}

