/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.HashSet;
import java.util.Set;

public class ValueSet<T> {
    private Set<T> values;
    private Boolean polarity;

    public ValueSet(Set<T> values, Boolean isPositive) {
        this.values = values;
        this.polarity = isPositive;
    }

    public static <T> ValueSet<T> create() {
        return new ValueSet(new HashSet(), null);
    }

    public static <T> ValueSet<T> create(Set<T> values, boolean polarity) {
        return new ValueSet<T>(values, polarity);
    }

    public Boolean getPolarity() {
        return this.isUnknown() ? null : this.polarity;
    }

    public boolean isUnknown() {
        return this.values == null;
    }

    public void setPolarity(boolean polarity) {
        this.polarity = polarity;
    }

    public Set<T> getValues() {
        return this.values;
    }

    public void merge(ValueSet<T> other) {
        if (other.isUnknown()) {
            if (this.isUnknown()) {
                this.values = null;
            } else {
                return;
            }
        }
        if (this.isUnknown()) {
            return;
        }
        if (this.polarity.booleanValue() && other.polarity.booleanValue()) {
            this.values.addAll(other.values);
            this.polarity = true;
        } else if (!this.polarity.booleanValue() && !other.polarity.booleanValue()) {
            this.values.retainAll(other.getValues());
            this.polarity = false;
        } else {
            this.values = null;
        }
    }

    public String toString() {
        return "ValueSet [values=" + this.values + ", polarity=" + this.polarity + "]";
    }
}

