/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformSubstitute;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.graph.NodeTransform;

public class VarExprListUtils {
    public static VarExprList createFromMap(Map<Var, Expr> map) {
        VarExprList result = new VarExprList();
        for (Map.Entry<Var, Expr> e : map.entrySet()) {
            Var v = e.getKey();
            Expr w = e.getValue();
            if (w.isVariable() && v.equals((Object)w.asVar())) {
                result.add(v);
                continue;
            }
            result.add(v, w);
        }
        return result;
    }

    public static VarExprList createFromVarMap(Map<Var, Var> varMap) {
        VarExprList result = new VarExprList();
        for (Map.Entry<Var, Var> e : varMap.entrySet()) {
            Var w;
            Var v = e.getKey();
            if (v.equals((Object)(w = e.getValue()))) {
                result.add(w);
                continue;
            }
            result.add(w, (Expr)new ExprVar(v));
        }
        return result;
    }

    public static Set<Var> getRefVars(VarExprList vel) {
        HashSet<Var> result = new HashSet<Var>();
        for (Map.Entry entry : vel.getExprs().entrySet()) {
            if (entry.getValue() == null) {
                result.add((Var)entry.getKey());
                continue;
            }
            Set vs = ExprVars.getVarsMentioned((Expr)((Expr)entry.getValue()));
            result.addAll(vs);
        }
        return result;
    }

    private static Expr transform(Expr expr, ExprTransform exprTransform) {
        if (expr == null || exprTransform == null) {
            return expr;
        }
        return ExprTransformer.transform((ExprTransform)exprTransform, (Expr)expr);
    }

    public static Map<Var, Expr> applyNodeTransform(Map<Var, Expr> varExpr, NodeTransform nodeTransform) {
        Map result = varExpr.entrySet().stream().collect(Collectors.toMap(e -> (Var)nodeTransform.apply(e.getKey()), e -> ((Expr)e.getValue()).applyNodeTransform(nodeTransform), (u, v) -> {
            throw new RuntimeException("Duplicate key");
        }, LinkedHashMap::new));
        return result;
    }

    public static VarExprList transform(VarExprList varExpr, ExprTransform exprTransform) {
        List vars = varExpr.getVars();
        VarExprList varExpr2 = new VarExprList();
        boolean changed = false;
        for (Var v : vars) {
            Expr e;
            Expr newVE = exprTransform.transform(new ExprVar(v));
            Var newV = newVE == null ? v : ((ExprVar)newVE).asVar();
            changed = !v.equals((Object)newV);
            Expr e2 = e = varExpr.getExpr(v);
            if (e != null) {
                e2 = VarExprListUtils.transform(e, exprTransform);
            }
            if (e2 == null) {
                varExpr2.add(newV);
            } else {
                varExpr2.add(newV, e2);
            }
            if (e == e2) continue;
            changed = true;
        }
        if (!changed) {
            return varExpr;
        }
        return varExpr2;
    }

    public static ExprTransform createExprTransform(Map<Var, Expr> varDefs) {
        Map tmp = varDefs.entrySet().stream().collect(Collectors.toMap(e -> ((Var)e.getKey()).getName(), Map.Entry::getValue, (u, v) -> {
            throw new RuntimeException("duplicate");
        }, LinkedHashMap::new));
        ExprTransformSubstitute result = new ExprTransformSubstitute(tmp);
        return result;
    }

    public static void replace(VarExprList dst, VarExprList src) {
        if (dst != src) {
            dst.clear();
            VarExprListUtils.copy(dst, src);
        }
    }

    public static void copy(VarExprList dst, VarExprList src) {
        for (Var v : src.getVars()) {
            Expr e = src.getExpr(v);
            if (e == null) {
                dst.add(v);
                continue;
            }
            dst.add(v, e);
        }
    }
}

