/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.model;

import org.aksw.jena_sparql_api.utils.model.NodeMapper;
import org.aksw.jena_sparql_api.utils.model.NodeMapperDelegating;
import org.aksw.jena_sparql_api.utils.model.NodeMapperPassthrough;
import org.aksw.jena_sparql_api.utils.model.NodeMapperRdfDatatype;
import org.aksw.jena_sparql_api.utils.model.NodeMapperUriOrString;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class NodeMapperFactory {
    public static final NodeMapper<Node> PASSTHROUGH = new NodeMapperPassthrough();
    public static final NodeMapper<String> string = NodeMapperFactory.from(String.class);
    public static final NodeMapper<String> DEFAULT_URI_OR_STRING = new NodeMapperUriOrString(str -> UrlValidator.getInstance().isValid(str));
    public static final NodeMapper<String> uriString = new NodeMapperDelegating<String>(String.class, Node::isURI, NodeFactory::createURI, Node::getURI);

    public static <T> NodeMapper<T> from(Class<T> clazz) {
        TypeMapper typeMapper = TypeMapper.getInstance();
        NodeMapper<T> result = NodeMapperFactory.from(clazz, typeMapper);
        return result;
    }

    public static <T> NodeMapper<T> from(Class<T> clazz, TypeMapper typeMapper) {
        RDFDatatype dtype = typeMapper.getTypeByClass(clazz);
        NodeMapperRdfDatatype result = new NodeMapperRdfDatatype(dtype);
        return result;
    }
}

