/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.model;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.aksw.jena_sparql_api.utils.model.NodeMapper;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;

public class NodeMapperRdfDatatype<T>
implements NodeMapper<T> {
    protected RDFDatatype dtype;

    public NodeMapperRdfDatatype(RDFDatatype dtype) {
        this.dtype = dtype;
    }

    @Override
    public boolean canMap(Node node) {
        boolean result = NodeMapperRdfDatatype.canMapCore(node, this.dtype);
        return result;
    }

    public static boolean canMapCore(Node node, RDFDatatype dtype) {
        boolean result = node.isLiteral() && dtype.isValidValue(node.getLiteralValue());
        return result;
    }

    @Override
    public Node toNode(T obj) {
        String lex = this.dtype.unparse(obj);
        Node result = NodeFactory.createLiteral((String)lex, (RDFDatatype)this.dtype);
        return result;
    }

    @Override
    public T toJava(Node node) {
        T result = NodeMapperRdfDatatype.toJavaCore(node, this.dtype);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T toJavaCore(Node node, RDFDatatype dtype) {
        Object obj;
        Class javaClass = dtype.getJavaClass();
        if (Number.class.isAssignableFrom(javaClass)) {
            String lex = node.getLiteralLexicalForm();
            if (javaClass.equals(BigDecimal.class)) {
                obj = new BigDecimal(lex);
                return (T)obj;
            }
            try {
                Method m;
                try {
                    m = javaClass.getMethod("valueOf", String.class);
                }
                catch (Exception e) {
                    throw new RuntimeException("No 'valueOf' method found on Numeric for parsing " + node + " against java type " + javaClass + " based on RDF type " + dtype);
                }
                obj = m.invoke(null, lex);
                return (T)obj;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        obj = node.getLiteralValue();
        return (T)obj;
    }

    @Override
    public Class<?> getJavaClass() {
        Class result = this.dtype.getJavaClass();
        return result;
    }
}

