/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.model;

import java.util.function.Predicate;
import org.aksw.jena_sparql_api.utils.model.NodeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.vocabulary.XSD;

public class NodeMapperUriOrString
implements NodeMapper<String> {
    protected Predicate<String> testForUri;

    public NodeMapperUriOrString(Predicate<String> testForUri) {
        this.testForUri = testForUri;
    }

    @Override
    public Class<?> getJavaClass() {
        return String.class;
    }

    @Override
    public boolean canMap(Node node) {
        boolean result = node.isURI() || node.isLiteral() && XSD.xstring.toString().equals(node.getLiteralDatatypeURI());
        return result;
    }

    @Override
    public Node toNode(String str) {
        boolean isUri = this.testForUri.test(str);
        Node result = isUri ? NodeFactory.createURI((String)str) : NodeFactory.createLiteral((String)str);
        return result;
    }

    @Override
    public String toJava(Node node) {
        return node.isURI() ? node.getURI() : node.getLiteralLexicalForm();
    }
}

