/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.model;

import java.util.AbstractList;
import java.util.List;

public class Quadlet<V>
extends AbstractList<V> {
    protected V g;
    protected V s;
    protected V p;
    protected V o;

    public Quadlet(List<V> components) {
        assert (components.size() == 4) : "there must be exactly 4 components";
        this.g = components.get(0);
        this.s = components.get(1);
        this.p = components.get(2);
        this.o = components.get(3);
    }

    public Quadlet(V g, V s, V p, V o) {
        this.g = g;
        this.s = s;
        this.p = p;
        this.o = o;
    }

    public V getGraph() {
        return this.g;
    }

    public V getSubject() {
        return this.s;
    }

    public V getPredicate() {
        return this.p;
    }

    public V getObject() {
        return this.o;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.g == null ? 0 : this.g.hashCode());
        result = 31 * result + (this.o == null ? 0 : this.o.hashCode());
        result = 31 * result + (this.p == null ? 0 : this.p.hashCode());
        result = 31 * result + (this.s == null ? 0 : this.s.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quadlet other = (Quadlet)obj;
        if (this.g == null ? other.g != null : !this.g.equals(other.g)) {
            return false;
        }
        if (this.o == null ? other.o != null : !this.o.equals(other.o)) {
            return false;
        }
        if (this.p == null ? other.p != null : !this.p.equals(other.p)) {
            return false;
        }
        return !(this.s == null ? other.s != null : !this.s.equals(other.s));
    }

    @Override
    public String toString() {
        return "Quadlet [g=" + this.g + ", s=" + this.s + ", p=" + this.p + ", o=" + this.o + "]";
    }

    @Override
    public V get(int index) {
        V result;
        switch (index) {
            case 0: {
                result = this.g;
                break;
            }
            case 1: {
                result = this.s;
                break;
            }
            case 2: {
                result = this.p;
                break;
            }
            case 3: {
                result = this.o;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return result;
    }

    @Override
    public int size() {
        return 4;
    }
}

