/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.model;

import com.google.common.collect.Streams;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.aksw.jena_sparql_api.utils.model.NodeMapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ResourceUtils {
    public static Resource asResource(Node node, Graph graph) {
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        RDFNode tmp = ModelUtils.convertGraphNodeToRDFNode((Node)node, (Model)model);
        Resource result = tmp.asResource();
        return result;
    }

    public static <T> Stream<T> asStream(ExtendedIterator<T> it) {
        Stream result = (Stream)Streams.stream(it).onClose(() -> it.close());
        return result;
    }

    public static <T> Optional<T> findFirst(Stream<T> stream) {
        Optional<T> result;
        try (Stream<T> tmp = stream;){
            result = stream.findFirst();
        }
        return result;
    }

    public static <T> Optional<T> findFirst(ExtendedIterator<T> stream) {
        Optional result = stream.nextOptional();
        stream.close();
        return result;
    }

    public static <T extends RDFNode> boolean canAsProperty(Statement stmt, Class<T> clazz) {
        boolean result = stmt.getObject().canAs(clazz);
        return result;
    }

    public static <T extends RDFNode> boolean canAsProperty(Statement stmt, Predicate<Node> nodeTest) {
        Node node = stmt.getObject().asNode();
        boolean result = nodeTest.test(node);
        return result;
    }

    public static <T extends RDFNode> T getPropertyValue(Statement stmt, Class<T> clazz) {
        RDFNode result = stmt.getObject().as(clazz);
        return (T)result;
    }

    public static <T> T getPropertyValue(Statement stmt, NodeMapper<T> nodeMapper) {
        Node node = stmt.getObject().asNode();
        T result = nodeMapper.toJava(node);
        return result;
    }

    public static boolean canAsLiteral(Statement stmt, Class<?> clazz) {
        boolean result = stmt.getObject().isLiteral() && Optional.ofNullable(stmt.getObject().asLiteral().getValue()).map(v -> clazz.isAssignableFrom(v.getClass())).isPresent();
        return result;
    }

    public static <T> T getLiteralValue(Statement stmt, Class<T> clazz) {
        Object result = stmt.getObject().asLiteral().getValue();
        return (T)result;
    }

    public static <T extends RDFNode> ExtendedIterator<Statement> listProperties(Resource s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p).filterKeep(stmt -> ResourceUtils.canAsProperty(stmt, clazz));
        return result;
    }

    public static <T extends RDFNode> ExtendedIterator<T> listPropertyValues(Resource s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p, clazz).mapWith(stmt -> ResourceUtils.getPropertyValue(stmt, clazz));
        return result;
    }

    public static StmtIterator listProperties(Resource s, Property p) {
        StmtIterator result = s.listProperties(p);
        return result;
    }

    public static ExtendedIterator<RDFNode> listPropertyValues(Resource s, Property p) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p).mapWith(Statement::getObject);
        return result;
    }

    public static Optional<Statement> getProperty(Resource s, Property p) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listProperties(s, p));
        return result;
    }

    public static Optional<RDFNode> getPropertyValue(Resource s, Property p) {
        Optional<RDFNode> result = ResourceUtils.getProperty(s, p).map(Statement::getObject);
        return result;
    }

    public static <T> ExtendedIterator<Statement> listProperties(Resource s, Property p, NodeMapper<T> nodeMapper) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p).filterKeep(stmt -> ResourceUtils.canAsProperty(stmt, nodeMapper::canMap));
        return result;
    }

    public static <T> ExtendedIterator<T> listPropertyValues(Resource s, Property p, NodeMapper<T> nodeMapper) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p, nodeMapper).mapWith(stmt -> ResourceUtils.getPropertyValue(stmt, nodeMapper));
        return result;
    }

    public static <T extends RDFNode> Optional<Statement> getProperty(Resource s, Property p, Class<T> clazz) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listProperties(s, p, clazz));
        return result;
    }

    public static <T extends RDFNode> Optional<T> getPropertyValue(Resource s, Property p, Class<T> clazz) {
        Optional<RDFNode> result = ResourceUtils.getProperty(s, p, clazz).map(stmt -> ResourceUtils.getPropertyValue(stmt, clazz));
        return result;
    }

    public static <T> ExtendedIterator<Statement> listLiteralProperties(Resource s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listProperties(s, p).filterKeep(stmt -> ResourceUtils.canAsLiteral(stmt, clazz));
        return result;
    }

    public static <T> ExtendedIterator<T> listLiteralPropertyValues(Resource s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listLiteralProperties(s, p, clazz).mapWith(stmt -> ResourceUtils.getLiteralValue(stmt, clazz));
        return result;
    }

    public static <T> Optional<Statement> getLiteralProperty(Resource s, Property p, Class<T> clazz) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listLiteralProperties(s, p, clazz));
        return result;
    }

    public static <T> Optional<T> getLiteralPropertyValue(Resource s, Property p, Class<T> clazz) {
        Optional<Object> result = ResourceUtils.getLiteralProperty(s, p, clazz).map(stmt -> ResourceUtils.getLiteralValue(stmt, clazz));
        return result;
    }

    public static StmtIterator listReverseProperties(RDFNode s, Property p) {
        StmtIterator result = s.getModel().listStatements(null, p, s);
        return result;
    }

    public static Optional<Statement> getReverseProperty(RDFNode s, Property p) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listReverseProperties(s, p));
        return result;
    }

    public static <T extends Resource> boolean isReverseProperty(Statement stmt, Class<T> clazz) {
        boolean result = stmt.getSubject().canAs(clazz);
        return result;
    }

    public static <T extends Resource> ExtendedIterator<Statement> listReverseProperties(RDFNode s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listReverseProperties(s, p).filterKeep(stmt -> ResourceUtils.isReverseProperty(stmt, clazz));
        return result;
    }

    public static <T extends Resource> Optional<Statement> getReverseProperty(RDFNode s, Property p, Class<T> clazz) {
        Optional<Statement> result = ResourceUtils.findFirst(ResourceUtils.listReverseProperties(s, p, clazz));
        return result;
    }

    public static ExtendedIterator<Resource> listReversePropertyValues(Resource s, Property p) {
        ExtendedIterator result = ResourceUtils.listReverseProperties((RDFNode)s, p).mapWith(Statement::getSubject);
        return result;
    }

    public static <T extends Resource> ExtendedIterator<T> listReversePropertyValues(RDFNode s, Property p, Class<T> clazz) {
        ExtendedIterator result = ResourceUtils.listReverseProperties(s, p, clazz).mapWith(stmt -> (Resource)stmt.getSubject().as(clazz));
        return result;
    }

    public static boolean addProperty(Resource s, Property p, RDFNode o) {
        boolean result = false;
        if (o != null && !s.hasProperty(p, o)) {
            s.addProperty(p, o);
            result = true;
        }
        return result;
    }

    public static boolean addLiteral(Resource s, Property p, Object o) {
        boolean result = false;
        if (o != null && !s.hasLiteral(p, o)) {
            s.addLiteral(p, o);
            result = true;
        }
        return result;
    }

    public static boolean addReverseProperty(RDFNode s, Property p, Resource o) {
        Resource newS = o.inModel(s.getModel());
        RDFNode newO = s;
        boolean result = ResourceUtils.addProperty(newS, p, newO);
        return result;
    }

    public static boolean replaceProperties(Model m, ExtendedIterator<Statement> removals, Statement stmt) {
        boolean result;
        boolean stmtSeen = false;
        while (removals.hasNext()) {
            Statement item = (Statement)removals.next();
            if (item.equals((Object)stmt)) {
                stmtSeen = true;
                continue;
            }
            removals.remove();
        }
        boolean bl = result = stmt != null && !stmtSeen;
        if (result) {
            m.add(stmt);
        }
        return result;
    }

    public static boolean setProperty(Resource s, Property p, RDFNode o) {
        boolean result = ResourceUtils.replaceProperties(s.getModel(), (ExtendedIterator<Statement>)ResourceUtils.listProperties(s, p), o == null ? null : s.getModel().createStatement(s, p, o));
        return result;
    }

    public static <S extends Resource> S setLiteralProperty(S s, Property p, Object o) {
        ResourceUtils.replaceProperties(s.getModel(), (ExtendedIterator<Statement>)ResourceUtils.listProperties(s, p), o == null ? null : s.getModel().createLiteralStatement(s, p, o));
        return s;
    }

    public static <T> boolean setProperty(Resource s, Property p, NodeMapper<T> nodeMapper, T value) {
        RDFNode o = value == null ? null : s.getModel().asRDFNode(nodeMapper.toNode(value));
        boolean result = ResourceUtils.replaceProperties(s.getModel(), ResourceUtils.listProperties(s, p, nodeMapper), o == null ? null : s.getModel().createStatement(s, p, o));
        return result;
    }

    public static <T> boolean updateLiteralProperty(Resource s, Property p, Class<T> clazz, T o) {
        boolean result = ResourceUtils.replaceProperties(s.getModel(), ResourceUtils.listLiteralProperties(s, p, clazz), o == null ? null : s.getModel().createLiteralStatement(s, p, o));
        return result;
    }

    public static <T extends RDFNode> boolean updateProperty(Resource s, Property p, Class<T> clazz, T o) {
        boolean result = ResourceUtils.replaceProperties(s.getModel(), ResourceUtils.listProperties(s, p, clazz), o == null ? null : s.getModel().createStatement(s, p, o));
        return result;
    }

    public static <T extends Resource> boolean setReverseProperty(RDFNode s, Property p, Class<T> clazz, T o) {
        boolean result = ResourceUtils.replaceProperties(s.getModel(), ResourceUtils.listReverseProperties(s, p, clazz), o == null ? null : s.getModel().createStatement(o, p, s));
        return result;
    }

    public static <T extends Resource> boolean hasProperty(Resource s, Property p, Class<T> clazz) {
        boolean result = ResourceUtils.getProperty(s, p, clazz).isPresent();
        return result;
    }

    public static boolean hasReverseProperty(RDFNode s, Property p) {
        boolean result = ResourceUtils.getReverseProperty(s, p).isPresent();
        return result;
    }

    public static <T extends Resource> boolean hasReverseProperty(RDFNode s, Property p, Class<T> clazz) {
        boolean result = ResourceUtils.getReverseProperty(s, p, clazz).isPresent();
        return result;
    }
}

