/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.model;

import java.util.AbstractSet;
import java.util.Iterator;
import org.aksw.jena_sparql_api.utils.model.ResourceUtils;
import org.apache.jena.ext.com.google.common.collect.Iterators;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class SetFromLiteralPropertyValues<T>
extends AbstractSet<T> {
    protected Resource subject;
    protected Property property;
    protected Class<T> clazz;

    public SetFromLiteralPropertyValues(Resource subject, Property property, Class<T> clazz) {
        this.subject = subject;
        this.property = property;
        this.clazz = clazz;
    }

    @Override
    public boolean add(T o) {
        boolean result = ResourceUtils.addLiteral(this.subject, this.property, o);
        return result;
    }

    @Override
    public void clear() {
        ResourceUtils.updateLiteralProperty(this.subject, this.property, this.clazz, null);
    }

    @Override
    public Iterator<T> iterator() {
        ExtendedIterator<T> result = ResourceUtils.listLiteralPropertyValues(this.subject, this.property, this.clazz);
        return result;
    }

    @Override
    public int size() {
        int result = Iterators.size(this.iterator());
        return result;
    }
}

