/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aksw.jena_sparql_api.utils.model.Directed;
import org.aksw.jena_sparql_api.utils.model.Triplet;

public class TripletImpl<V, E>
implements Triplet<V, E> {
    protected V subject;
    protected E predicate;
    protected V object;

    public TripletImpl(V subject, E predicate, V object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public static <V, E> Triplet<V, Directed<E>> makeDirected(Triplet<V, E> in, V source) {
        TripletImpl<V, Directed<Directed<Directed<Directed<Directed<Directed<Directed<Directed<E>>>>>>>>> result;
        int dir = TripletImpl.getDirection(in, source);
        TripletImpl<V, Directed<Directed<Directed<Directed<Directed<Directed<Directed<Directed<E>>>>>>>>> tripletImpl = (dir & 1) != 0 ? new TripletImpl<V, Directed<Directed<Directed<Directed<Directed<Directed<Directed<Directed<E>>>>>>>>>(in.getSubject(), new Directed<E>(in.getPredicate(), false), in.getObject()) : (result = (dir & 2) != 0 ? new TripletImpl<V, Directed<E>>(in.getObject(), new Directed<E>(in.getPredicate(), true), in.getSubject()) : null);
        if (result == null) {
            throw new RuntimeException("Should not happen");
        }
        return result;
    }

    public static <V, E> Triplet<V, E> makeUndirected(Triplet<V, Directed<E>> in) {
        Directed<E> dp = in.getPredicate();
        TripletImpl<V, E> result = dp.isReverse() ? new TripletImpl<V, E>(in.getObject(), dp.getValue(), in.getSubject()) : new TripletImpl<V, E>(in.getSubject(), dp.getValue(), in.getObject());
        return result;
    }

    public static <V, E> Triplet<V, E> create(V s, E e, V o, boolean reverse) {
        TripletImpl<V, E> result = !reverse ? new TripletImpl<V, E>(s, e, o) : new TripletImpl<V, E>(o, e, s);
        return result;
    }

    public static <V> V getSource(Triplet<V, ?> triplet, boolean reverse) {
        V result = reverse ? triplet.getObject() : triplet.getSubject();
        return result;
    }

    public static <V> V getTarget(Triplet<V, ?> triplet, boolean reverse) {
        V result = TripletImpl.getSource(triplet, !reverse);
        return result;
    }

    public static <V> V getTarget(Triplet<V, ?> triplet, Object source) {
        V result = triplet.getSubject().equals(source) ? triplet.getObject() : triplet.getSubject();
        return result;
    }

    public static List<Boolean> getDirections(Triplet<?, ?> triplet, Object node) {
        List<Boolean> result;
        int dir = TripletImpl.getDirection(triplet, node);
        switch (dir) {
            case 0: {
                result = Collections.emptyList();
                break;
            }
            case 1: {
                result = Collections.singletonList(false);
                break;
            }
            case 2: {
                result = Collections.singletonList(true);
                break;
            }
            case 3: {
                result = Arrays.asList(false, true);
                break;
            }
            default: {
                throw new RuntimeException("Should not happen");
            }
        }
        return result;
    }

    public static int getDirection(Triplet<?, ?> triplet, Object node) {
        int result = (triplet.getSubject().equals(node) ? 1 : 0) | (triplet.getObject().equals(node) ? 2 : 0);
        return result;
    }

    @Override
    public V getSubject() {
        return this.subject;
    }

    @Override
    public E getPredicate() {
        return this.predicate;
    }

    @Override
    public V getObject() {
        return this.object;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.object == null ? 0 : this.object.hashCode());
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TripletImpl other = (TripletImpl)obj;
        if (this.object == null ? other.object != null : !this.object.equals(other.object)) {
            return false;
        }
        if (this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate)) {
            return false;
        }
        return !(this.subject == null ? other.subject != null : !this.subject.equals(other.subject));
    }

    public String toString() {
        return "Triplet [subject=" + this.subject + ", predicate=" + this.predicate + ", object=" + this.object + "]";
    }
}

