/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.utils.transform;

import java.util.Collection;
import java.util.Stack;
import org.aksw.jena_sparql_api.backports.syntaxtransform.ElementTransformCopyBase;
import org.aksw.jena_sparql_api.backports.syntaxtransform.ElementTransformer;
import org.aksw.jena_sparql_api.utils.ExprListUtils;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.VarGeneratorBlacklist;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.PatternVars;

public class ElementTransformDatasetDescription
extends ElementTransformCopyBase {
    protected ExprList defaultGraphExprs;
    protected ExprList namedGraphExprs;
    protected Stack<Node> graphs;
    protected Generator<Var> varGen;

    public ElementTransformDatasetDescription(Stack<Node> graphs, Generator<Var> varGen, ExprList defaultGraphExprs, ExprList namedGraphExprs) {
        this.graphs = graphs;
        this.varGen = varGen;
        this.defaultGraphExprs = defaultGraphExprs;
        this.namedGraphExprs = namedGraphExprs;
    }

    public static ElementTransformDatasetDescription create(Stack<Node> graphs, Element e, DatasetDescription dd) {
        Collection vars = PatternVars.vars((Element)e);
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create("v", (Collection<Var>)vars);
        ExprList defaultGraphExprs = ExprListUtils.fromUris(dd.getDefaultGraphURIs());
        ExprList namedGraphExprs = ExprListUtils.fromUris(dd.getNamedGraphURIs());
        ElementTransformDatasetDescription result = new ElementTransformDatasetDescription(graphs, varGen, defaultGraphExprs, namedGraphExprs);
        return result;
    }

    @Override
    public Element transform(ElementTriplesBlock el) {
        Element result = this.applyDefaultGraphs((Element)el);
        return result;
    }

    @Override
    public Element transform(ElementPathBlock el) {
        Element result = this.applyDefaultGraphs((Element)el);
        return result;
    }

    public Element applyDefaultGraphs(Element el) {
        Element result;
        if (this.graphs.isEmpty() && !this.defaultGraphExprs.isEmpty()) {
            Var v = this.varGen.next();
            result = ElementTransformDatasetDescription.applyGraphs(this.varGen, (Node)v, el, this.defaultGraphExprs);
        } else {
            result = el;
        }
        return result;
    }

    public static Element applyGraphs(Generator<Var> varGen, Node gn, Element elt1, ExprList exprs) {
        ElementNamedGraph result;
        if (!exprs.isEmpty()) {
            Var v;
            if (gn.isURI() || gn.isLiteral()) {
                v = varGen.next();
                ExprList tmp = new ExprList();
                tmp.add((Expr)NodeValue.makeNode((Node)gn));
                tmp.addAll(exprs);
            } else if (gn.isVariable()) {
                v = (Var)gn;
                ExprList tmp = exprs;
            } else if (gn.isBlank()) {
                v = varGen.next();
                ExprList tmp = exprs;
            } else {
                throw new RuntimeException("Unexpected case");
            }
            ExprVar ev = new ExprVar(v);
            ElementNamedGraph el = new ElementNamedGraph((Node)v, elt1);
            ElementFilter filter = new ElementFilter((Expr)new E_OneOf((Expr)ev, exprs));
            ElementGroup group = new ElementGroup();
            group.addElement((Element)el);
            group.addElement((Element)filter);
            result = group;
        } else {
            result = new ElementNamedGraph(gn, elt1);
        }
        return result;
    }

    @Override
    public Element transform(ElementNamedGraph el, Node gn, Element elt1) {
        Element result = ElementTransformDatasetDescription.applyGraphs(this.varGen, gn, elt1, this.namedGraphExprs);
        return result;
    }

    public static Query rewrite(Query query) {
        Query result;
        DatasetDescription dd = query.getDatasetDescription();
        if (dd != null) {
            result = query.cloneQuery();
            Element before = result.getQueryPattern();
            Element after = ElementTransformDatasetDescription.rewrite(before, dd);
            result.setQueryPattern(after);
        } else {
            result = query;
        }
        return result;
    }

    public static Element rewrite(Element element, DatasetDescription dd) {
        final Stack<Node> graphs = new Stack<Node>();
        ExprTransformCopy exprTransform = new ExprTransformCopy();
        ElementTransformDatasetDescription elementTransform = ElementTransformDatasetDescription.create(graphs, element, dd);
        ElementVisitorBase beforeVisitor = new ElementVisitorBase(){

            public void visit(ElementNamedGraph el) {
                graphs.push(el.getGraphNameNode());
            }
        };
        ElementVisitorBase afterVisitor = new ElementVisitorBase(){

            public void visit(ElementNamedGraph el) {
                graphs.pop();
            }
        };
        Element result = ElementTransformer.transform(element, elementTransform, (ExprTransform)exprTransform, (ElementVisitor)beforeVisitor, (ElementVisitor)afterVisitor);
        return result;
    }

    public static void main(String[] args) {
        Query query = QueryFactory.create((String)"SELECT * { { ?s ?p ?o . Graph ?x { ?a ?b ?c } } Union { Graph ?g { ?s ?p ?o } } }");
        query.addGraphURI("dg1");
        query.addGraphURI("dg2");
        query.addNamedGraphURI("ng1");
        query.addNamedGraphURI("ng2");
        Query tmp = ElementTransformDatasetDescription.rewrite(query);
        Op op = Algebra.compile((Query)tmp);
        Op op2 = Transformer.transformSkipService((Transform)new TransformFilterPlacement(), (Op)op);
        tmp = OpAsQuery.asQuery((Op)op2);
        System.out.println(tmp);
    }
}

