/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rad.test;

import org.alfresco.rad.SpringContextHolder;
import org.alfresco.service.ServiceRegistry;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.springframework.context.ApplicationContext;

public abstract class AbstractAlfrescoIT {
    private ApplicationContext applicationContext = null;
    private ServiceRegistry serviceRegistry = null;
    @Rule
    public MethodRule testAnnouncer = new MethodRule(){

        public Statement apply(Statement base, FrameworkMethod method, Object target) {
            System.out.println("Running " + AbstractAlfrescoIT.this.getClassName() + " Integration Test: " + method.getName() + "()");
            return base;
        }
    };

    protected String getClassName() {
        Class<?> enclosingClass = this.getClass().getEnclosingClass();
        if (enclosingClass != null) {
            return enclosingClass.getName();
        }
        return this.getClass().getName();
    }

    protected ApplicationContext getApplicationContext() {
        SpringContextHolder springContextHolder;
        if (this.applicationContext == null && (springContextHolder = SpringContextHolder.Instance()) != null) {
            this.applicationContext = springContextHolder.getApplicationContext();
        }
        return this.applicationContext;
    }

    protected ServiceRegistry getServiceRegistry() {
        Object bean;
        ApplicationContext ctx;
        if (this.serviceRegistry == null && (ctx = this.getApplicationContext()) != null && (bean = ctx.getBean("ServiceRegistry")) != null && bean instanceof ServiceRegistry) {
            this.serviceRegistry = (ServiceRegistry)bean;
        }
        return this.serviceRegistry;
    }
}

