/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.maven.plugin;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class VersionMojo
extends AbstractMojo {
    private static final DateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("yyMMddHHmm");
    protected String snapshotSuffix;
    protected boolean snapshotToTimestamp;
    protected String customVersionSuffix;
    private String propertyName;
    protected MavenProject project;
    protected String version;

    protected String getNormalizedVersion() {
        int separatorIndex = this.version.indexOf(this.snapshotSuffix);
        String normalizedVersion = this.version;
        if (separatorIndex > -1) {
            normalizedVersion = this.version.substring(0, separatorIndex);
            this.getLog().info((CharSequence)("Removed -SNAPSHOT suffix from version - " + normalizedVersion));
        }
        if (this.customVersionSuffix != null && this.customVersionSuffix.length() > 0) {
            normalizedVersion = normalizedVersion + "." + this.customVersionSuffix;
            this.getLog().info((CharSequence)("Added custom suffix to version - " + normalizedVersion));
        } else if (this.snapshotToTimestamp) {
            normalizedVersion = normalizedVersion + "." + TIMESTAMP_FORMATTER.format(new Date());
            this.getLog().info((CharSequence)("Added timestamp to version - " + normalizedVersion));
        }
        return normalizedVersion;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.project.getProperties().put(this.propertyName, this.getNormalizedVersion());
    }
}

